@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Health Monitor Description
 * @property details Health Monitor Details
 * @property id Health Monitor Id
 * @property name Health Monitor Name
 */
public data class HealthMonitorResponse(
    public val details: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.HealthMonitorResponse):
            HealthMonitorResponse = HealthMonitorResponse(
            details = javaType.details(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
