@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Migration Progress
 * @property completionPercentage Completion Percentage
 * @property progressMessage Progress Message
 */
public data class MigrationProgressResponse(
    public val completionPercentage: Double? = null,
    public val progressMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.MigrationProgressResponse):
            MigrationProgressResponse = MigrationProgressResponse(
            completionPercentage = javaType.completionPercentage().map({ args0 -> args0 }).orElse(null),
            progressMessage = javaType.progressMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
