@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.AzureADMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * AzureADMetrics resource.
 * Azure REST API version: 2020-07-01-preview. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * ## Example Usage
 * ### azureADMetricsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureADMetric = new AzureNative.AadIam.AzureADMetric("azureADMetric", new()
 *     {
 *         AzureADMetricsName = "ddb1",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewAzureADMetric(ctx, "azureADMetric", &aadiam.AzureADMetricArgs{
 * 			AzureADMetricsName: pulumi.String("ddb1"),
 * 			Location:           pulumi.String("West US"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Tags:               nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.AzureADMetric;
 * import com.pulumi.azurenative.aadiam.AzureADMetricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureADMetric = new AzureADMetric("azureADMetric", AzureADMetricArgs.builder()
 *             .azureADMetricsName("ddb1")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:AzureADMetric ddb1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.aadiam/azureADMetrics/{azureADMetricsName}
 * ```
 * @property azureADMetricsName Name of the azureADMetrics instance.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName Name of an Azure resource group.
 * @property tags Resource tags.
 */
public data class AzureADMetricArgs(
    public val azureADMetricsName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.AzureADMetricArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.AzureADMetricArgs =
        com.pulumi.azurenative.aadiam.AzureADMetricArgs.builder()
            .azureADMetricsName(azureADMetricsName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureADMetricArgs].
 */
@PulumiTagMarker
public class AzureADMetricArgsBuilder internal constructor() {
    private var azureADMetricsName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the azureADMetrics instance.
     */
    @JvmName("ffqfqpcstedfmadl")
    public suspend fun azureADMetricsName(`value`: Output<String>) {
        this.azureADMetricsName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nyuksbooikvsqyxr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("adnlpkbhcwdoogju")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dlukhkgmexmwhoxk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the azureADMetrics instance.
     */
    @JvmName("soivfgecqfwriglq")
    public suspend fun azureADMetricsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureADMetricsName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bakacmevkqgbcedl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("seyrmabumujllyhe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ssshbrahjeyyqcle")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rcqcumnutdyukqcp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureADMetricArgs = AzureADMetricArgs(
        azureADMetricsName = azureADMetricsName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
