@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.kotlin.outputs.LogSettingsResponse
import com.pulumi.azurenative.aadiam.kotlin.outputs.LogSettingsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DiagnosticSetting].
 */
@PulumiTagMarker
public class DiagnosticSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiagnosticSettingArgs = DiagnosticSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiagnosticSettingArgsBuilder.() -> Unit) {
        val builder = DiagnosticSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DiagnosticSetting {
        val builtJavaResource = com.pulumi.azurenative.aadiam.DiagnosticSetting(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DiagnosticSetting(builtJavaResource)
    }
}

/**
 * The diagnostic setting resource.
 * Azure REST API version: 2017-04-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2017-04-01-preview.
 * ## Example Usage
 * ### BatchAccountDelete
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticSetting = new AzureNative.AadIam.DiagnosticSetting("diagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/eventhubs/myeventhub/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.AadIam.Inputs.LogSettingsArgs
 *             {
 *                 Category = "AuditLogs",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.AadIam.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         Name = "mysetting",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewDiagnosticSetting(ctx, "diagnosticSetting", &aadiam.DiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/eventhubs/myeventhub/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []aadiam.LogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("AuditLogs"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			Name:             pulumi.String("mysetting"),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:      pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.DiagnosticSetting;
 * import com.pulumi.azurenative.aadiam.DiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticSetting = new DiagnosticSetting("diagnosticSetting", DiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/eventhubs/myeventhub/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("category", "AuditLogs"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .name("mysetting")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:DiagnosticSetting mysetting /providers/microsoft.aadiam/diagnosticSettings/{name}
 * ```
 */
public class DiagnosticSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.aadiam.DiagnosticSetting,
) : KotlinCustomResource(javaResource, DiagnosticSettingMapper) {
    /**
     * The resource Id for the event hub authorization rule.
     */
    public val eventHubAuthorizationRuleId: Output<String>?
        get() = javaResource.eventHubAuthorizationRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the event hub. If none is specified, the default event hub will be selected.
     */
    public val eventHubName: Output<String>?
        get() = javaResource.eventHubName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of logs settings.
     */
    public val logs: Output<List<LogSettingsResponse>>?
        get() = javaResource.logs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    public val serviceBusRuleId: Output<String>?
        get() = javaResource.serviceBusRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The workspace ID (resource ID of a Log Analytics workspace) for a Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    public val workspaceId: Output<String>?
        get() = javaResource.workspaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DiagnosticSettingMapper : ResourceMapper<DiagnosticSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.aadiam.DiagnosticSetting::class == javaResource::class

    override fun map(javaResource: Resource): DiagnosticSetting = DiagnosticSetting(
        javaResource as
            com.pulumi.azurenative.aadiam.DiagnosticSetting,
    )
}

/**
 * @see [DiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiagnosticSetting].
 */
public suspend fun diagnosticSetting(
    name: String,
    block: suspend DiagnosticSettingResourceBuilder.() -> Unit,
): DiagnosticSetting {
    val builder = DiagnosticSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiagnosticSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diagnosticSetting(name: String): DiagnosticSetting {
    val builder = DiagnosticSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
