@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.DiagnosticSettingArgs.builder
import com.pulumi.azurenative.aadiam.kotlin.inputs.LogSettingsArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.LogSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The diagnostic setting resource.
 * Azure REST API version: 2017-04-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2017-04-01-preview.
 * ## Example Usage
 * ### BatchAccountDelete
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticSetting = new AzureNative.AadIam.DiagnosticSetting("diagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/eventhubs/myeventhub/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.AadIam.Inputs.LogSettingsArgs
 *             {
 *                 Category = "AuditLogs",
 *                 Enabled = true,
 *                 RetentionPolicy = new AzureNative.AadIam.Inputs.RetentionPolicyArgs
 *                 {
 *                     Days = 0,
 *                     Enabled = false,
 *                 },
 *             },
 *         },
 *         Name = "mysetting",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewDiagnosticSetting(ctx, "diagnosticSetting", &aadiam.DiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/eventhubs/myeventhub/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []aadiam.LogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("AuditLogs"),
 * 					Enabled:  pulumi.Bool(true),
 * 					RetentionPolicy: {
 * 						Days:    pulumi.Int(0),
 * 						Enabled: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			Name:             pulumi.String("mysetting"),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:      pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.DiagnosticSetting;
 * import com.pulumi.azurenative.aadiam.DiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticSetting = new DiagnosticSetting("diagnosticSetting", DiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/eventhubs/myeventhub/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("category", "AuditLogs"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("days", 0),
 *                     Map.entry("enabled", false)
 *                 ))
 *             ))
 *             .name("mysetting")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:DiagnosticSetting mysetting /providers/microsoft.aadiam/diagnosticSettings/{name}
 * ```
 * @property eventHubAuthorizationRuleId The resource Id for the event hub authorization rule.
 * @property eventHubName The name of the event hub. If none is specified, the default event hub will be selected.
 * @property logs The list of logs settings.
 * @property name The name of the diagnostic setting.
 * @property serviceBusRuleId The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
 * @property storageAccountId The resource ID of the storage account to which you would like to send Diagnostic Logs.
 * @property workspaceId The workspace ID (resource ID of a Log Analytics workspace) for a Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
 */
public data class DiagnosticSettingArgs(
    public val eventHubAuthorizationRuleId: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val logs: Output<List<LogSettingsArgs>>? = null,
    public val name: Output<String>? = null,
    public val serviceBusRuleId: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.DiagnosticSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.DiagnosticSettingArgs =
        com.pulumi.azurenative.aadiam.DiagnosticSettingArgs.builder()
            .eventHubAuthorizationRuleId(eventHubAuthorizationRuleId?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .logs(logs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serviceBusRuleId(serviceBusRuleId?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiagnosticSettingArgs].
 */
@PulumiTagMarker
public class DiagnosticSettingArgsBuilder internal constructor() {
    private var eventHubAuthorizationRuleId: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var logs: Output<List<LogSettingsArgs>>? = null

    private var name: Output<String>? = null

    private var serviceBusRuleId: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("dhcvkwwcdqinhcgw")
    public suspend fun eventHubAuthorizationRuleId(`value`: Output<String>) {
        this.eventHubAuthorizationRuleId = value
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("epowdkiscqiefpon")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("atsivtqbprneylkp")
    public suspend fun logs(`value`: Output<List<LogSettingsArgs>>) {
        this.logs = value
    }

    @JvmName("yypswqxuxqooaskd")
    public suspend fun logs(vararg values: Output<LogSettingsArgs>) {
        this.logs = Output.all(values.asList())
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("kjclnnkibnjkxubi")
    public suspend fun logs(values: List<Output<LogSettingsArgs>>) {
        this.logs = Output.all(values)
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("cehpipffxgdfjvrn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("tlqorberfyjwpvni")
    public suspend fun serviceBusRuleId(`value`: Output<String>) {
        this.serviceBusRuleId = value
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("nilvydlengkamucl")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The workspace ID (resource ID of a Log Analytics workspace) for a Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("fqwswxqhnbeyvlee")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("haltqdeadexwdyjb")
    public suspend fun eventHubAuthorizationRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubAuthorizationRuleId = mapped
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("cwuhuthydgujfwel")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("emnunxdiadjmdhba")
    public suspend fun logs(`value`: List<LogSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("soakesujlggojpem")
    public suspend fun logs(argument: List<suspend LogSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LogSettingsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("lhcatukcujsrdpgr")
    public suspend fun logs(vararg argument: suspend LogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LogSettingsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("ucjgvksrwigmkvmm")
    public suspend fun logs(argument: suspend LogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LogSettingsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("ylvxiglwrrrxqhvo")
    public suspend fun logs(vararg values: LogSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("mecxxhymqgcoenpr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("ayjqqxovlnyvrnyj")
    public suspend fun serviceBusRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusRuleId = mapped
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("gfldrccrywnkndbj")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The workspace ID (resource ID of a Log Analytics workspace) for a Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("awysoegxmsudjkjs")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): DiagnosticSettingArgs = DiagnosticSettingArgs(
        eventHubAuthorizationRuleId = eventHubAuthorizationRuleId,
        eventHubName = eventHubName,
        logs = logs,
        name = name,
        serviceBusRuleId = serviceBusRuleId,
        storageAccountId = storageAccountId,
        workspaceId = workspaceId,
    )
}
