@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.aadiam.kotlin.inputs.PrivateEndpointArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.PrivateEndpointArgsBuilder
import com.pulumi.azurenative.aadiam.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.azurenative.aadiam.kotlin.inputs.TagsResourceArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.TagsResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private endpoint connection resource.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * ## Example Usage
 * ### AadiamPutPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.AadIam.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PolicyName = "example-policy-5849",
 *         PrivateEndpoint = new AzureNative.AadIam.Inputs.PrivateEndpointArgs
 *         {
 *             Id = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/microsoft.aadiam/privateLinkForAzureAD/ddb1/privateLinkConnections/{privateEndpointConnection name}",
 *         },
 *         PrivateEndpointConnectionName = "{privateEndpointConnection name}",
 *         PrivateLinkServiceConnectionState = new AzureNative.AadIam.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "You may pass",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "resourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &aadiam.PrivateEndpointConnectionArgs{
 * 			PolicyName: pulumi.String("example-policy-5849"),
 * 			PrivateEndpoint: &aadiam.PrivateEndpointArgs{
 * 				Id: pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/microsoft.aadiam/privateLinkForAzureAD/ddb1/privateLinkConnections/{privateEndpointConnection name}"),
 * 			},
 * 			PrivateEndpointConnectionName: pulumi.String("{privateEndpointConnection name}"),
 * 			PrivateLinkServiceConnectionState: &aadiam.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("You may pass"),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.PrivateEndpointConnection;
 * import com.pulumi.azurenative.aadiam.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .policyName("example-policy-5849")
 *             .privateEndpoint(Map.of("id", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/microsoft.aadiam/privateLinkForAzureAD/ddb1/privateLinkConnections/{privateEndpointConnection name}"))
 *             .privateEndpointConnectionName("{privateEndpointConnection name}")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "You may pass"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("resourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:PrivateEndpointConnection {privateEndpointConnection name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.aadiam/privateLinkForAzureAd/{policyName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property policyName The name of the private link policy in Azure AD.
 * @property privateEndpoint Properties of the private endpoint object.
 * @property privateEndpointConnectionName The PrivateEndpointConnection name.
 * @property privateLinkConnectionTags Updated tag information to set into the PrivateLinkConnection instance.
 * @property privateLinkServiceConnectionState Approval state of the private link connection.
 * @property resourceGroupName Name of an Azure resource group.
 */
public data class PrivateEndpointConnectionArgs(
    public val policyName: Output<String>? = null,
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkConnectionTags: Output<TagsResourceArgs>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.aadiam.PrivateEndpointConnectionArgs.builder()
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkConnectionTags(
                privateLinkConnectionTags?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var policyName: Output<String>? = null

    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkConnectionTags: Output<TagsResourceArgs>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the private link policy in Azure AD.
     */
    @JvmName("ytcukemcyclojour")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Properties of the private endpoint object.
     */
    @JvmName("ovkqncnoeqprgoey")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The PrivateEndpointConnection name.
     */
    @JvmName("ejrlongqofwtohwm")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Updated tag information to set into the PrivateLinkConnection instance.
     */
    @JvmName("kabmtcfncmsafypl")
    public suspend fun privateLinkConnectionTags(`value`: Output<TagsResourceArgs>) {
        this.privateLinkConnectionTags = value
    }

    /**
     * @param value Approval state of the private link connection.
     */
    @JvmName("vqrgfkdjjsgoskux")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("kjndmxavqibdfgqe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the private link policy in Azure AD.
     */
    @JvmName("qafasrqdstotnnqt")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Properties of the private endpoint object.
     */
    @JvmName("qcqbbkqynneottid")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Properties of the private endpoint object.
     */
    @JvmName("dputgghngjrdjvea")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The PrivateEndpointConnection name.
     */
    @JvmName("xxaetuljghlxpclo")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Updated tag information to set into the PrivateLinkConnection instance.
     */
    @JvmName("tmvbuxhdnqrjcsyh")
    public suspend fun privateLinkConnectionTags(`value`: TagsResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkConnectionTags = mapped
    }

    /**
     * @param argument Updated tag information to set into the PrivateLinkConnection instance.
     */
    @JvmName("nvhkjdidxitljvie")
    public suspend
    fun privateLinkConnectionTags(argument: suspend TagsResourceArgsBuilder.() -> Unit) {
        val toBeMapped = TagsResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkConnectionTags = mapped
    }

    /**
     * @param value Approval state of the private link connection.
     */
    @JvmName("ireinkbepvmbbnhg")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Approval state of the private link connection.
     */
    @JvmName("kdgeiwxwxfonxlca")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("guhxmqaujfkamtqk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        policyName = policyName,
        privateEndpoint = privateEndpoint,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkConnectionTags = privateLinkConnectionTags,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
