@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
 */
public enum class Category(
    public val javaValue: com.pulumi.azurenative.aadiam.enums.Category,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.enums.Category> {
    AuditLogs(com.pulumi.azurenative.aadiam.enums.Category.AuditLogs),
    SignInLogs(com.pulumi.azurenative.aadiam.enums.Category.SignInLogs),
    ;

    override fun toJava(): com.pulumi.azurenative.aadiam.enums.Category = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aadiam.enums.Category): Category =
            Category.values().first { it.javaValue == javaType }
    }
}
