@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.inputs

import com.pulumi.azurenative.aadiam.inputs.LogSettingsArgs.builder
import com.pulumi.azurenative.aadiam.kotlin.enums.Category
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
 * @property category Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
 * @property enabled A value indicating whether this log is enabled.
 * @property retentionPolicy The retention policy for this log.
 */
public data class LogSettingsArgs(
    public val category: Output<Either<String, Category>>? = null,
    public val enabled: Output<Boolean>,
    public val retentionPolicy: Output<RetentionPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.inputs.LogSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.inputs.LogSettingsArgs =
        com.pulumi.azurenative.aadiam.inputs.LogSettingsArgs.builder()
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .retentionPolicy(
                retentionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LogSettingsArgs].
 */
@PulumiTagMarker
public class LogSettingsArgsBuilder internal constructor() {
    private var category: Output<Either<String, Category>>? = null

    private var enabled: Output<Boolean>? = null

    private var retentionPolicy: Output<RetentionPolicyArgs>? = null

    /**
     * @param value Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("lsxgkqlprgybfirb")
    public suspend fun category(`value`: Output<Either<String, Category>>) {
        this.category = value
    }

    /**
     * @param value A value indicating whether this log is enabled.
     */
    @JvmName("dxulgjwnxeddjqvd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The retention policy for this log.
     */
    @JvmName("agsosdrykgssomgi")
    public suspend fun retentionPolicy(`value`: Output<RetentionPolicyArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("tvakjoijcwfxtomw")
    public suspend fun category(`value`: Either<String, Category>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("engohpddnlwpprxn")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Category>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("qokevidlmqtkejff")
    public fun category(`value`: Category) {
        val toBeMapped = Either.ofRight<String, Category>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value A value indicating whether this log is enabled.
     */
    @JvmName("ymvvlnyjoxuiokdy")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The retention policy for this log.
     */
    @JvmName("jqsvddnhskvblgft")
    public suspend fun retentionPolicy(`value`: RetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument The retention policy for this log.
     */
    @JvmName("vuuscnabyfvhccwf")
    public suspend fun retentionPolicy(argument: suspend RetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    internal fun build(): LogSettingsArgs = LogSettingsArgs(
        category = category,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        retentionPolicy = retentionPolicy,
    )
}
