@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.inputs

import com.pulumi.azurenative.aadiam.inputs.PrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Private endpoint object properties.
 * @property id Full identifier of the private endpoint resource.
 */
public data class PrivateEndpointArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.inputs.PrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.inputs.PrivateEndpointArgs =
        com.pulumi.azurenative.aadiam.inputs.PrivateEndpointArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointArgs].
 */
@PulumiTagMarker
public class PrivateEndpointArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Full identifier of the private endpoint resource.
     */
    @JvmName("qpahqetwmbkdemht")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Full identifier of the private endpoint resource.
     */
    @JvmName("lkjupwfienkvqxym")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): PrivateEndpointArgs = PrivateEndpointArgs(
        id = id,
    )
}
