@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.inputs

import com.pulumi.azurenative.aadiam.inputs.TagsResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkConnection instance.
 * @property tags Resource tags
 */
public data class TagsResourceArgs(
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.inputs.TagsResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.inputs.TagsResourceArgs =
        com.pulumi.azurenative.aadiam.inputs.TagsResourceArgs.builder()
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TagsResourceArgs].
 */
@PulumiTagMarker
public class TagsResourceArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource tags
     */
    @JvmName("oxrukdhunvsfguer")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("nwhlafomewyrifij")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("erpxkggfoijlqsqy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TagsResourceArgs = TagsResourceArgs(
        tags = tags,
    )
}
