@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.addons.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status of the Canonical support plan.
 * @property id The id of the ARM resource, e.g. "/subscriptions/{id}/providers/Microsoft.Addons/supportProvider/{supportProviderName}/supportPlanTypes/{planTypeName}".
 * @property name The name of the Canonical support plan, i.e. "essential", "standard" or "advanced".
 * @property provisioningState The provisioning state of the resource.
 * @property type Microsoft.Addons/supportProvider
 */
public data class GetSupportPlanTypeResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.addons.outputs.GetSupportPlanTypeResult):
            GetSupportPlanTypeResult = GetSupportPlanTypeResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
