@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SensorIntegrationResponse
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SensorIntegrationResponse.Companion.toKotlin as sensorIntegrationResponseToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataManagerForAgricultureResource].
 */
@PulumiTagMarker
public class DataManagerForAgricultureResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataManagerForAgricultureResourceArgs = DataManagerForAgricultureResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataManagerForAgricultureResourceArgsBuilder.() -> Unit) {
        val builder = DataManagerForAgricultureResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataManagerForAgricultureResource {
        val builtJavaResource =
            com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataManagerForAgricultureResource(builtJavaResource)
    }
}

/**
 * Data Manager For Agriculture ARM Resource.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### DataManagerForAgricultureResources_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataManagerForAgricultureResource = new AzureNative.AgFoodPlatform.DataManagerForAgricultureResource("dataManagerForAgricultureResource", new()
 *     {
 *         DataManagerForAgricultureResourceName = "examples-farmbeatsResourceName",
 *         Location = "eastus2",
 *         ResourceGroupName = "examples-rg",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewDataManagerForAgricultureResource(ctx, "dataManagerForAgricultureResource", &agfoodplatform.DataManagerForAgricultureResourceArgs{
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-farmbeatsResourceName"),
 * 			Location:                              pulumi.String("eastus2"),
 * 			ResourceGroupName:                     pulumi.String("examples-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResource;
 * import com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataManagerForAgricultureResource = new DataManagerForAgricultureResource("dataManagerForAgricultureResource", DataManagerForAgricultureResourceArgs.builder()
 *             .dataManagerForAgricultureResourceName("examples-farmbeatsResourceName")
 *             .location("eastus2")
 *             .resourceGroupName("examples-rg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:DataManagerForAgricultureResource examples-farmbeatsResourceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}
 * ```
 */
public class DataManagerForAgricultureResource internal constructor(
    override val javaResource:
    com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResource,
) : KotlinCustomResource(javaResource, DataManagerForAgricultureResourceMapper) {
    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Uri of the Data Manager For Agriculture instance.
     */
    public val instanceUri: Output<String>
        get() = javaResource.instanceUri().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoints.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Data Manager For Agriculture instance provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Property to allow or block public traffic for an Azure Data Manager For Agriculture resource.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sensor integration request model.
     */
    public val sensorIntegration: Output<SensorIntegrationResponse>?
        get() = javaResource.sensorIntegration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sensorIntegrationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataManagerForAgricultureResourceMapper :
    ResourceMapper<DataManagerForAgricultureResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResource::class == javaResource::class

    override fun map(javaResource: Resource): DataManagerForAgricultureResource =
        DataManagerForAgricultureResource(
            javaResource as
                com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResource,
        )
}

/**
 * @see [DataManagerForAgricultureResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataManagerForAgricultureResource].
 */
public suspend fun dataManagerForAgricultureResource(
    name: String,
    block: suspend DataManagerForAgricultureResourceResourceBuilder.() -> Unit,
):
    DataManagerForAgricultureResource {
    val builder = DataManagerForAgricultureResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataManagerForAgricultureResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataManagerForAgricultureResource(name: String): DataManagerForAgricultureResource {
    val builder = DataManagerForAgricultureResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
