@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public enum class PrivateEndpointServiceConnectionStatus(
    public val javaValue:
    com.pulumi.azurenative.agfoodplatform.enums.PrivateEndpointServiceConnectionStatus,
) :
    ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.enums.PrivateEndpointServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.agfoodplatform.enums.PrivateEndpointServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.agfoodplatform.enums.PrivateEndpointServiceConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.agfoodplatform.enums.PrivateEndpointServiceConnectionStatus.Rejected),
    ;

    override fun toJava():
        com.pulumi.azurenative.agfoodplatform.enums.PrivateEndpointServiceConnectionStatus = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.enums.PrivateEndpointServiceConnectionStatus):
            PrivateEndpointServiceConnectionStatus =
            PrivateEndpointServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
