@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.GetDataConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataConnectorName Connector name.
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataConnectorPlainArgs(
    public val dataConnectorName: String,
    public val dataManagerForAgricultureResourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.GetDataConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.GetDataConnectorPlainArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.GetDataConnectorPlainArgs.builder()
            .dataConnectorName(dataConnectorName.let({ args0 -> args0 }))
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName.let({ args0 ->
                    args0
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetDataConnectorPlainArgsBuilder internal constructor() {
    private var dataConnectorName: String? = null

    private var dataManagerForAgricultureResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Connector name.
     */
    @JvmName("mkhuttqqxivbclka")
    public suspend fun dataConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataConnectorName = mapped
    }

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("rvmjnrutipyiofnn")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggdotqvgckruysch")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataConnectorPlainArgs = GetDataConnectorPlainArgs(
        dataConnectorName = dataConnectorName ?: throw PulumiNullFieldException("dataConnectorName"),
        dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName ?: throw
            PulumiNullFieldException("dataManagerForAgricultureResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
