@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.GetExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property extensionId Id of extension resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetExtensionPlainArgs(
    public val dataManagerForAgricultureResourceName: String,
    public val extensionId: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.GetExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.GetExtensionPlainArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.GetExtensionPlainArgs.builder()
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName.let({ args0 ->
                    args0
                }),
            )
            .extensionId(extensionId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetExtensionPlainArgsBuilder internal constructor() {
    private var dataManagerForAgricultureResourceName: String? = null

    private var extensionId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("ujmdmibwasolywdg")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value Id of extension resource.
     */
    @JvmName("yxvaunosuuoiqtwu")
    public suspend fun extensionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yurarectrfkusweo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExtensionPlainArgs = GetExtensionPlainArgs(
        dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName ?: throw
            PulumiNullFieldException("dataManagerForAgricultureResourceName"),
        extensionId = extensionId ?: throw PulumiNullFieldException("extensionId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
