@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.SensorIntegrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sensor integration request model.
 * @property enabled Sensor integration enable state.
 */
public data class SensorIntegrationArgs(
    public val enabled: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.SensorIntegrationArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.SensorIntegrationArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.SensorIntegrationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SensorIntegrationArgs].
 */
@PulumiTagMarker
public class SensorIntegrationArgsBuilder internal constructor() {
    private var enabled: Output<String>? = null

    /**
     * @param value Sensor integration enable state.
     */
    @JvmName("ilakhbhlposwgxum")
    public suspend fun enabled(`value`: Output<String>) {
        this.enabled = value
    }

    /**
     * @param value Sensor integration enable state.
     */
    @JvmName("cpinvhmowouxrgdt")
    public suspend fun enabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): SensorIntegrationArgs = SensorIntegrationArgs(
        enabled = enabled,
    )
}
