@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ApiKeyAuthCredentials class for ApiKey based Auth.
 * @property apiKey Properties of the key vault.
 * @property kind Enum for different types of AuthCredentials supported.
 * Expected value is 'ApiKeyAuthCredentials'.
 */
public data class ApiKeyAuthCredentialsResponse(
    public val apiKey: KeyVaultPropertiesResponse,
    public val kind: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.ApiKeyAuthCredentialsResponse):
            ApiKeyAuthCredentialsResponse = ApiKeyAuthCredentialsResponse(
            apiKey = javaType.apiKey().let({ args0 ->
                com.pulumi.azurenative.agfoodplatform.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
            }),
            kind = javaType.kind(),
        )
    }
}
