@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Extension resource.
 * @property additionalApiProperties Additional Api Properties.
 * @property eTag The ETag value to implement optimistic concurrency.
 * @property extensionApiDocsLink Extension api docs link.
 * @property extensionAuthLink Extension auth link.
 * @property extensionCategory Extension category. e.g. weather/sensor/satellite.
 * @property extensionId Extension Id.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property installedExtensionVersion Installed extension version.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetExtensionResult(
    public val additionalApiProperties: Map<String, ApiPropertiesResponse>,
    public val eTag: String,
    public val extensionApiDocsLink: String,
    public val extensionAuthLink: String,
    public val extensionCategory: String,
    public val extensionId: String,
    public val id: String,
    public val installedExtensionVersion: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.GetExtensionResult):
            GetExtensionResult = GetExtensionResult(
            additionalApiProperties = javaType.additionalApiProperties().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.agfoodplatform.kotlin.outputs.ApiPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            eTag = javaType.eTag(),
            extensionApiDocsLink = javaType.extensionApiDocsLink(),
            extensionAuthLink = javaType.extensionAuthLink(),
            extensionCategory = javaType.extensionCategory(),
            extensionId = javaType.extensionId(),
            id = javaType.id(),
            installedExtensionVersion = javaType.installedExtensionVersion(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
