@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.azurenative.alertsmanagement.ActionRuleByNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Action rule object containing target scope, conditions and suppression logic
 * Azure REST API version: 2019-05-05-preview. Prior API version in Azure Native 1.x: 2019-05-05-preview.
 * Other available API versions: 2018-11-02-privatepreview.
 * ## Example Usage
 * ### PutActionRule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var actionRuleByName = new AzureNative.AlertsManagement.ActionRuleByName("actionRuleByName", new()
 *     {
 *         ActionRuleName = "DailySuppression",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.SuppressionArgs
 *         {
 *             Conditions = new AzureNative.AlertsManagement.Inputs.ConditionsArgs
 *             {
 *                 MonitorCondition = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "Fired",
 *                     },
 *                 },
 *                 MonitorService = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "Platform",
 *                         "Application Insights",
 *                     },
 *                 },
 *                 Severity = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "Sev0",
 *                         "Sev2",
 *                     },
 *                 },
 *                 TargetResourceType = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "NotEquals",
 *                     Values = new[]
 *                     {
 *                         "Microsoft.Compute/VirtualMachines",
 *                     },
 *                 },
 *             },
 *             Description = "Action rule on resource group for daily suppression",
 *             Scope = new AzureNative.AlertsManagement.Inputs.ScopeArgs
 *             {
 *                 ScopeType = "ResourceGroup",
 *                 Values = new[]
 *                 {
 *                     "/subscriptions/1e3ff1c0-771a-4119-a03b-be82a51e232d/resourceGroups/alertscorrelationrg",
 *                 },
 *             },
 *             Status = "Enabled",
 *             SuppressionConfig = new AzureNative.AlertsManagement.Inputs.SuppressionConfigArgs
 *             {
 *                 RecurrenceType = "Daily",
 *                 Schedule = new AzureNative.AlertsManagement.Inputs.SuppressionScheduleArgs
 *                 {
 *                     EndDate = "12/18/2018",
 *                     EndTime = "14:00:00",
 *                     StartDate = "12/09/2018",
 *                     StartTime = "06:00:00",
 *                 },
 *             },
 *             Type = "Suppression",
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewActionRuleByName(ctx, "actionRuleByName", &alertsmanagement.ActionRuleByNameArgs{
 * 			ActionRuleName: pulumi.String("DailySuppression"),
 * 			Location:       pulumi.String("Global"),
 * 			Properties: alertsmanagement.Suppression{
 * 				Conditions: alertsmanagement.Conditions{
 * 					MonitorCondition: alertsmanagement.Condition{
 * 						Operator: "Equals",
 * 						Values: []string{
 * 							"Fired",
 * 						},
 * 					},
 * 					MonitorService: alertsmanagement.Condition{
 * 						Operator: "Equals",
 * 						Values: []string{
 * 							"Platform",
 * 							"Application Insights",
 * 						},
 * 					},
 * 					Severity: alertsmanagement.Condition{
 * 						Operator: "Equals",
 * 						Values: []string{
 * 							"Sev0",
 * 							"Sev2",
 * 						},
 * 					},
 * 					TargetResourceType: alertsmanagement.Condition{
 * 						Operator: "NotEquals",
 * 						Values: []string{
 * 							"Microsoft.Compute/VirtualMachines",
 * 						},
 * 					},
 * 				},
 * 				Description: "Action rule on resource group for daily suppression",
 * 				Scope: alertsmanagement.Scope{
 * 					ScopeType: "ResourceGroup",
 * 					Values: []string{
 * 						"/subscriptions/1e3ff1c0-771a-4119-a03b-be82a51e232d/resourceGroups/alertscorrelationrg",
 * 					},
 * 				},
 * 				Status: "Enabled",
 * 				SuppressionConfig: alertsmanagement.SuppressionConfig{
 * 					RecurrenceType: "Daily",
 * 					Schedule: alertsmanagement.SuppressionSchedule{
 * 						EndDate:   "12/18/2018",
 * 						EndTime:   "14:00:00",
 * 						StartDate: "12/09/2018",
 * 						StartTime: "06:00:00",
 * 					},
 * 				},
 * 				Type: "Suppression",
 * 			},
 * 			ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.ActionRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.ActionRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var actionRuleByName = new ActionRuleByName("actionRuleByName", ActionRuleByNameArgs.builder()
 *             .actionRuleName("DailySuppression")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("conditions", Map.ofEntries(
 *                     Map.entry("monitorCondition", Map.ofEntries(
 *                         Map.entry("operator", "Equals"),
 *                         Map.entry("values", "Fired")
 *                     )),
 *                     Map.entry("monitorService", Map.ofEntries(
 *                         Map.entry("operator", "Equals"),
 *                         Map.entry("values",
 *                             "Platform",
 *                             "Application Insights")
 *                     )),
 *                     Map.entry("severity", Map.ofEntries(
 *                         Map.entry("operator", "Equals"),
 *                         Map.entry("values",
 *                             "Sev0",
 *                             "Sev2")
 *                     )),
 *                     Map.entry("targetResourceType", Map.ofEntries(
 *                         Map.entry("operator", "NotEquals"),
 *                         Map.entry("values", "Microsoft.Compute/VirtualMachines")
 *                     ))
 *                 )),
 *                 Map.entry("description", "Action rule on resource group for daily suppression"),
 *                 Map.entry("scope", Map.ofEntries(
 *                     Map.entry("scopeType", "ResourceGroup"),
 *                     Map.entry("values", "/subscriptions/1e3ff1c0-771a-4119-a03b-be82a51e232d/resourceGroups/alertscorrelationrg")
 *                 )),
 *                 Map.entry("status", "Enabled"),
 *                 Map.entry("suppressionConfig", Map.ofEntries(
 *                     Map.entry("recurrenceType", "Daily"),
 *                     Map.entry("schedule", Map.ofEntries(
 *                         Map.entry("endDate", "12/18/2018"),
 *                         Map.entry("endTime", "14:00:00"),
 *                         Map.entry("startDate", "12/09/2018"),
 *                         Map.entry("startTime", "06:00:00")
 *                     ))
 *                 )),
 *                 Map.entry("type", "Suppression")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:alertsmanagement:ActionRuleByName DailySuppression /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{actionRuleName}
 * ```
 * @property actionRuleName The name of action rule that needs to be created/updated
 * @property location Resource location
 * @property properties action rule properties
 * @property resourceGroupName Resource group name where the resource is created.
 * @property tags Resource tags
 */
public data class ActionRuleByNameArgs(
    public val actionRuleName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.ActionRuleByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.ActionRuleByNameArgs =
        com.pulumi.azurenative.alertsmanagement.ActionRuleByNameArgs.builder()
            .actionRuleName(actionRuleName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ActionRuleByNameArgs].
 */
@PulumiTagMarker
public class ActionRuleByNameArgsBuilder internal constructor() {
    private var actionRuleName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of action rule that needs to be created/updated
     */
    @JvmName("kqfiypnsepepmlkn")
    public suspend fun actionRuleName(`value`: Output<String>) {
        this.actionRuleName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("htjkiekvxmyxdkxx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value action rule properties
     */
    @JvmName("narulhxesyuqqgrw")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value Resource group name where the resource is created.
     */
    @JvmName("cbdqhjicmlxbpvkh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("sqabxnkggnyjgtdu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of action rule that needs to be created/updated
     */
    @JvmName("rmfiwwtvjxqaaacl")
    public suspend fun actionRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionRuleName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("ielgrqbulxxjulbj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value action rule properties
     */
    @JvmName("nbeleebdfiaocdcc")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Resource group name where the resource is created.
     */
    @JvmName("owthhhwpyjadeaph")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("trqobayhutxhtonr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("qobdhehkhbxkrvsk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ActionRuleByNameArgs = ActionRuleByNameArgs(
        actionRuleName = actionRuleName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
