@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.ConditionArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.Field
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.Operator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Condition to trigger an alert processing rule.
 * @property field Field for a given condition.
 * @property operator Operator for a given condition.
 * @property values List of values to match for a given condition.
 */
public data class ConditionArgs(
    public val `field`: Output<Either<String, Field>>? = null,
    public val `operator`: Output<Either<String, Operator>>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.ConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.ConditionArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.ConditionArgs.builder()
            .`field`(
                `field`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`operator`(
                `operator`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConditionArgs].
 */
@PulumiTagMarker
public class ConditionArgsBuilder internal constructor() {
    private var `field`: Output<Either<String, Field>>? = null

    private var `operator`: Output<Either<String, Operator>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Field for a given condition.
     */
    @JvmName("plotqfhmeimjryin")
    public suspend fun `field`(`value`: Output<Either<String, Field>>) {
        this.`field` = value
    }

    /**
     * @param value Operator for a given condition.
     */
    @JvmName("xruopxjqdlgyornb")
    public suspend fun `operator`(`value`: Output<Either<String, Operator>>) {
        this.`operator` = value
    }

    /**
     * @param value List of values to match for a given condition.
     */
    @JvmName("iumkkurltxumhajg")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("yvkhklytlljvcjke")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values List of values to match for a given condition.
     */
    @JvmName("pdgojsrnyvvhshpq")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Field for a given condition.
     */
    @JvmName("bkjadnokunwvsmuj")
    public suspend fun `field`(`value`: Either<String, Field>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Field for a given condition.
     */
    @JvmName("ugxqixbfuhytjxxb")
    public fun `field`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Field>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Field for a given condition.
     */
    @JvmName("ptysneygmxscteow")
    public fun `field`(`value`: Field) {
        val toBeMapped = Either.ofRight<String, Field>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Operator for a given condition.
     */
    @JvmName("eoihmjssffjwdslm")
    public suspend fun `operator`(`value`: Either<String, Operator>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Operator for a given condition.
     */
    @JvmName("wheeiymwdkjmgnnx")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Operator for a given condition.
     */
    @JvmName("cqojaqxdgkxdijly")
    public fun `operator`(`value`: Operator) {
        val toBeMapped = Either.ofRight<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value List of values to match for a given condition.
     */
    @JvmName("jcxpxbosusvymrls")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values List of values to match for a given condition.
     */
    @JvmName("sjsmuetmwvwowadr")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ConditionArgs = ConditionArgs(
        `field` = `field`,
        `operator` = `operator`,
        values = values,
    )
}
