@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.SuppressionScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schedule for a given suppression configuration.
 * @property endDate End date for suppression
 * @property endTime End date for suppression
 * @property recurrenceValues Specifies the values for recurrence pattern
 * @property startDate Start date for suppression
 * @property startTime Start time for suppression
 */
public data class SuppressionScheduleArgs(
    public val endDate: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val recurrenceValues: Output<List<Int>>? = null,
    public val startDate: Output<String>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.SuppressionScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.SuppressionScheduleArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.SuppressionScheduleArgs.builder()
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .recurrenceValues(recurrenceValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .startDate(startDate?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SuppressionScheduleArgs].
 */
@PulumiTagMarker
public class SuppressionScheduleArgsBuilder internal constructor() {
    private var endDate: Output<String>? = null

    private var endTime: Output<String>? = null

    private var recurrenceValues: Output<List<Int>>? = null

    private var startDate: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value End date for suppression
     */
    @JvmName("mnhvmepsbilqklgm")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value End date for suppression
     */
    @JvmName("kwyykjhjidoodlql")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Specifies the values for recurrence pattern
     */
    @JvmName("gbkyagjltgwsnsog")
    public suspend fun recurrenceValues(`value`: Output<List<Int>>) {
        this.recurrenceValues = value
    }

    @JvmName("jyfbuvxxiusgxdqg")
    public suspend fun recurrenceValues(vararg values: Output<Int>) {
        this.recurrenceValues = Output.all(values.asList())
    }

    /**
     * @param values Specifies the values for recurrence pattern
     */
    @JvmName("byupxxdeqitkiydg")
    public suspend fun recurrenceValues(values: List<Output<Int>>) {
        this.recurrenceValues = Output.all(values)
    }

    /**
     * @param value Start date for suppression
     */
    @JvmName("fgmvdvjvlwfonvwm")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value Start time for suppression
     */
    @JvmName("ikbvcahfygbekdhw")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value End date for suppression
     */
    @JvmName("jjrqxoliqmxxffqw")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value End date for suppression
     */
    @JvmName("barubceninbpxvkp")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Specifies the values for recurrence pattern
     */
    @JvmName("uuylbeyfwoipmygn")
    public suspend fun recurrenceValues(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceValues = mapped
    }

    /**
     * @param values Specifies the values for recurrence pattern
     */
    @JvmName("jvqqccbpogdqbyra")
    public suspend fun recurrenceValues(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceValues = mapped
    }

    /**
     * @param value Start date for suppression
     */
    @JvmName("ccaxiktgscisavxg")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value Start time for suppression
     */
    @JvmName("ptkpdbcerrsgfnkk")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): SuppressionScheduleArgs = SuppressionScheduleArgs(
        endDate = endDate,
        endTime = endTime,
        recurrenceValues = recurrenceValues,
        startDate = startDate,
        startTime = startTime,
    )
}
