@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.ThrottlingInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Optional throttling information for the alert rule.
 * @property duration The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes
 */
public data class ThrottlingInformationArgs(
    public val duration: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.ThrottlingInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.ThrottlingInformationArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.ThrottlingInformationArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThrottlingInformationArgs].
 */
@PulumiTagMarker
public class ThrottlingInformationArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    /**
     * @param value The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes
     */
    @JvmName("duxymkeojrybxiol")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes
     */
    @JvmName("lvjlwactxildrjtn")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    internal fun build(): ThrottlingInformationArgs = ThrottlingInformationArgs(
        duration = duration,
    )
}
