@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin

import com.pulumi.azurenative.analysisservices.kotlin.outputs.GatewayDetailsResponse
import com.pulumi.azurenative.analysisservices.kotlin.outputs.IPv4FirewallSettingsResponse
import com.pulumi.azurenative.analysisservices.kotlin.outputs.ResourceSkuResponse
import com.pulumi.azurenative.analysisservices.kotlin.outputs.ServerAdministratorsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.analysisservices.kotlin.outputs.GatewayDetailsResponse.Companion.toKotlin as gatewayDetailsResponseToKotlin
import com.pulumi.azurenative.analysisservices.kotlin.outputs.IPv4FirewallSettingsResponse.Companion.toKotlin as iPv4FirewallSettingsResponseToKotlin
import com.pulumi.azurenative.analysisservices.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin as resourceSkuResponseToKotlin
import com.pulumi.azurenative.analysisservices.kotlin.outputs.ServerAdministratorsResponse.Companion.toKotlin as serverAdministratorsResponseToKotlin

/**
 * Builder for [ServerDetails].
 */
@PulumiTagMarker
public class ServerDetailsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerDetailsArgs = ServerDetailsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerDetailsArgsBuilder.() -> Unit) {
        val builder = ServerDetailsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServerDetails {
        val builtJavaResource =
            com.pulumi.azurenative.analysisservices.ServerDetails(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerDetails(builtJavaResource)
    }
}

/**
 * Represents an instance of an Analysis Services resource.
 * Azure REST API version: 2017-08-01. Prior API version in Azure Native 1.x: 2017-08-01.
 * Other available API versions: 2017-08-01-beta.
 * ## Example Usage
 * ### Create a server.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverDetails = new AzureNative.AnalysisServices.ServerDetails("serverDetails", new()
 *     {
 *         AsAdministrators = new AzureNative.AnalysisServices.Inputs.ServerAdministratorsArgs
 *         {
 *             Members = new[]
 *             {
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com",
 *             },
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         ServerName = "azsdktest",
 *         Sku = new AzureNative.AnalysisServices.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "S1",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/analysisservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := analysisservices.NewServerDetails(ctx, "serverDetails", &analysisservices.ServerDetailsArgs{
 * 			AsAdministrators: &analysisservices.ServerAdministratorsArgs{
 * 				Members: pulumi.StringArray{
 * 					pulumi.String("azsdktest@microsoft.com"),
 * 					pulumi.String("azsdktest2@microsoft.com"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			ServerName:        pulumi.String("azsdktest"),
 * 			Sku: &analysisservices.ResourceSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("S1"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.analysisservices.ServerDetails;
 * import com.pulumi.azurenative.analysisservices.ServerDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverDetails = new ServerDetails("serverDetails", ServerDetailsArgs.builder()
 *             .asAdministrators(Map.of("members",
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com"))
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .serverName("azsdktest")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "S1"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("testKey", "testValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:analysisservices:ServerDetails azsdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}
 * ```
 */
public class ServerDetails internal constructor(
    override val javaResource: com.pulumi.azurenative.analysisservices.ServerDetails,
) : KotlinCustomResource(javaResource, ServerDetailsMapper) {
    /**
     * A collection of AS server administrators
     */
    public val asAdministrators: Output<ServerAdministratorsResponse>?
        get() = javaResource.asAdministrators().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverAdministratorsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The SAS container URI to the backup container.
     */
    public val backupBlobContainerUri: Output<String>?
        get() = javaResource.backupBlobContainerUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The gateway details configured for the AS server.
     */
    public val gatewayDetails: Output<GatewayDetailsResponse>?
        get() = javaResource.gatewayDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gatewayDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The firewall settings for the AS server.
     */
    public val ipV4FirewallSettings: Output<IPv4FirewallSettingsResponse>?
        get() = javaResource.ipV4FirewallSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> iPv4FirewallSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Location of the Analysis Services resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The managed mode of the server (0 = not managed, 1 = managed).
     */
    public val managedMode: Output<Int>?
        get() = javaResource.managedMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Analysis Services resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment state of Analysis Services resource. The provisioningState is to indicate states for resource provisioning.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * How the read-write server's participation in the query pool is controlled.<br/>It can have the following values: <ul><li>readOnly - indicates that the read-write server is intended not to participate in query operations</li><li>all - indicates that the read-write server can participate in query operations</li></ul>Specifying readOnly when capacity is 1 results in error.
     */
    public val querypoolConnectionMode: Output<String>?
        get() = javaResource.querypoolConnectionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The full name of the Analysis Services resource.
     */
    public val serverFullName: Output<String>
        get() = javaResource.serverFullName().applyValue({ args0 -> args0 })

    /**
     * The server monitor mode for AS server
     */
    public val serverMonitorMode: Output<Int>?
        get() = javaResource.serverMonitorMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU of the Analysis Services resource.
     */
    public val sku: Output<ResourceSkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceSkuResponseToKotlin(args0)
            })
        })

    /**
     * The current state of Analysis Services resource. The state is to indicate more states outside of resource provisioning.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of additional resource provisioning properties.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the Analysis Services resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerDetailsMapper : ResourceMapper<ServerDetails> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.analysisservices.ServerDetails::class == javaResource::class

    override fun map(javaResource: Resource): ServerDetails = ServerDetails(
        javaResource as
            com.pulumi.azurenative.analysisservices.ServerDetails,
    )
}

/**
 * @see [ServerDetails].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerDetails].
 */
public suspend fun serverDetails(
    name: String,
    block: suspend ServerDetailsResourceBuilder.() -> Unit,
): ServerDetails {
    val builder = ServerDetailsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerDetails].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverDetails(name: String): ServerDetails {
    val builder = ServerDetailsResourceBuilder()
    builder.name(name)
    return builder.build()
}
