@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an instance of an Analysis Services resource.
 * @property asAdministrators A collection of AS server administrators
 * @property backupBlobContainerUri The SAS container URI to the backup container.
 * @property gatewayDetails The gateway details configured for the AS server.
 * @property id An identifier that represents the Analysis Services resource.
 * @property ipV4FirewallSettings The firewall settings for the AS server.
 * @property location Location of the Analysis Services resource.
 * @property managedMode The managed mode of the server (0 = not managed, 1 = managed).
 * @property name The name of the Analysis Services resource.
 * @property provisioningState The current deployment state of Analysis Services resource. The provisioningState is to indicate states for resource provisioning.
 * @property querypoolConnectionMode How the read-write server's participation in the query pool is controlled.<br/>It can have the following values: <ul><li>readOnly - indicates that the read-write server is intended not to participate in query operations</li><li>all - indicates that the read-write server can participate in query operations</li></ul>Specifying readOnly when capacity is 1 results in error.
 * @property serverFullName The full name of the Analysis Services resource.
 * @property serverMonitorMode The server monitor mode for AS server
 * @property sku The SKU of the Analysis Services resource.
 * @property state The current state of Analysis Services resource. The state is to indicate more states outside of resource provisioning.
 * @property tags Key-value pairs of additional resource provisioning properties.
 * @property type The type of the Analysis Services resource.
 */
public data class GetServerDetailsResult(
    public val asAdministrators: ServerAdministratorsResponse? = null,
    public val backupBlobContainerUri: String? = null,
    public val gatewayDetails: GatewayDetailsResponse? = null,
    public val id: String,
    public val ipV4FirewallSettings: IPv4FirewallSettingsResponse? = null,
    public val location: String,
    public val managedMode: Int? = null,
    public val name: String,
    public val provisioningState: String,
    public val querypoolConnectionMode: String? = null,
    public val serverFullName: String,
    public val serverMonitorMode: Int? = null,
    public val sku: ResourceSkuResponse,
    public val state: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.analysisservices.outputs.GetServerDetailsResult):
            GetServerDetailsResult = GetServerDetailsResult(
            asAdministrators = javaType.asAdministrators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.analysisservices.kotlin.outputs.ServerAdministratorsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            backupBlobContainerUri = javaType.backupBlobContainerUri().map({ args0 -> args0 }).orElse(null),
            gatewayDetails = javaType.gatewayDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.analysisservices.kotlin.outputs.GatewayDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            ipV4FirewallSettings = javaType.ipV4FirewallSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.analysisservices.kotlin.outputs.IPv4FirewallSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            managedMode = javaType.managedMode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            querypoolConnectionMode = javaType.querypoolConnectionMode().map({ args0 -> args0 }).orElse(null),
            serverFullName = javaType.serverFullName(),
            serverMonitorMode = javaType.serverMonitorMode().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.analysisservices.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin(args0)
            }),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
