@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.kotlin.outputs.DeploymentServerResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.apicenter.kotlin.outputs.DeploymentServerResponse.Companion.toKotlin as deploymentServerResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Deployment].
 */
@PulumiTagMarker
public class DeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentArgs = DeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentArgsBuilder.() -> Unit) {
        val builder = DeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Deployment {
        val builtJavaResource = com.pulumi.azurenative.apicenter.Deployment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Deployment(builtJavaResource)
    }
}

/**
 * API deployment entity.
 * Azure REST API version: 2024-03-01.
 * ## Example Usage
 * ### Deployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.ApiCenter.Deployment("deployment", new()
 *     {
 *         ApiName = "echo-api",
 *         DefinitionId = "/workspaces/default/apis/echo-api/versions/2023-01-01/definitions/openapi",
 *         DeploymentName = "production",
 *         Description = "Public cloud production deployment.",
 *         EnvironmentId = "/workspaces/default/environments/production",
 *         ResourceGroupName = "contoso-resources",
 *         Server = new AzureNative.ApiCenter.Inputs.DeploymentServerArgs
 *         {
 *             RuntimeUri = new[]
 *             {
 *                 "https://api.contoso.com",
 *             },
 *         },
 *         ServiceName = "contoso",
 *         State = "active",
 *         Title = "Production deployment",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewDeployment(ctx, "deployment", &apicenter.DeploymentArgs{
 * 			ApiName:           pulumi.String("echo-api"),
 * 			DefinitionId:      pulumi.String("/workspaces/default/apis/echo-api/versions/2023-01-01/definitions/openapi"),
 * 			DeploymentName:    pulumi.String("production"),
 * 			Description:       pulumi.String("Public cloud production deployment."),
 * 			EnvironmentId:     pulumi.String("/workspaces/default/environments/production"),
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			Server: &apicenter.DeploymentServerArgs{
 * 				RuntimeUri: pulumi.StringArray{
 * 					pulumi.String("https://api.contoso.com"),
 * 				},
 * 			},
 * 			ServiceName:   pulumi.String("contoso"),
 * 			State:         pulumi.String("active"),
 * 			Title:         pulumi.String("Production deployment"),
 * 			WorkspaceName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.Deployment;
 * import com.pulumi.azurenative.apicenter.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .apiName("echo-api")
 *             .definitionId("/workspaces/default/apis/echo-api/versions/2023-01-01/definitions/openapi")
 *             .deploymentName("production")
 *             .description("Public cloud production deployment.")
 *             .environmentId("/workspaces/default/environments/production")
 *             .resourceGroupName("contoso-resources")
 *             .server(Map.of("runtimeUri", "https://api.contoso.com"))
 *             .serviceName("contoso")
 *             .state("active")
 *             .title("Production deployment")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:Deployment production /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/deployments/{deploymentName}
 * ```
 */
public class Deployment internal constructor(
    override val javaResource: com.pulumi.azurenative.apicenter.Deployment,
) : KotlinCustomResource(javaResource, DeploymentMapper) {
    /**
     * The custom metadata defined for API catalog entities.
     */
    public val customProperties: Output<Any>?
        get() = javaResource.customProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API center-scoped definition resource ID.
     */
    public val definitionId: Output<String>?
        get() = javaResource.definitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the deployment.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API center-scoped environment resource ID.
     */
    public val environmentId: Output<String>?
        get() = javaResource.environmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The deployment server
     */
    public val server: Output<DeploymentServerResponse>?
        get() = javaResource.server().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deploymentServerResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * State of API deployment.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * API deployment title
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeploymentMapper : ResourceMapper<Deployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apicenter.Deployment::class == javaResource::class

    override fun map(javaResource: Resource): Deployment = Deployment(
        javaResource as
            com.pulumi.azurenative.apicenter.Deployment,
    )
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Deployment].
 */
public suspend fun deployment(name: String, block: suspend DeploymentResourceBuilder.() -> Unit):
    Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployment(name: String): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
