@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.MetadataSchemaArgs.builder
import com.pulumi.azurenative.apicenter.kotlin.inputs.MetadataAssignmentArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.MetadataAssignmentArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Metadata schema entity. Used to define metadata for the entities in API catalog.
 * Azure REST API version: 2024-03-01.
 * ## Example Usage
 * ### MetadataSchemas_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metadataSchema = new AzureNative.ApiCenter.MetadataSchema("metadataSchema", new()
 *     {
 *         AssignedTo = new[]
 *         {
 *             new AzureNative.ApiCenter.Inputs.MetadataAssignmentArgs
 *             {
 *                 Deprecated = true,
 *                 Entity = "api",
 *             },
 *         },
 *         MetadataSchemaName = "author",
 *         ResourceGroupName = "contoso-resources",
 *         Schema = "{\"type\":\"string\", \"title\":\"Author\", pattern: \"^[a-zA-Z]+$\"}",
 *         ServiceName = "contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewMetadataSchema(ctx, "metadataSchema", &apicenter.MetadataSchemaArgs{
 * 			AssignedTo: []apicenter.MetadataAssignmentArgs{
 * 				{
 * 					Deprecated: pulumi.Bool(true),
 * 					Entity:     pulumi.String("api"),
 * 				},
 * 			},
 * 			MetadataSchemaName: pulumi.String("author"),
 * 			ResourceGroupName:  pulumi.String("contoso-resources"),
 * 			Schema:             pulumi.String("{\"type\":\"string\", \"title\":\"Author\", pattern: \"^[a-zA-Z]+$\"}"),
 * 			ServiceName:        pulumi.String("contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.MetadataSchema;
 * import com.pulumi.azurenative.apicenter.MetadataSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metadataSchema = new MetadataSchema("metadataSchema", MetadataSchemaArgs.builder()
 *             .assignedTo(Map.ofEntries(
 *                 Map.entry("deprecated", true),
 *                 Map.entry("entity", "api")
 *             ))
 *             .metadataSchemaName("author")
 *             .resourceGroupName("contoso-resources")
 *             .schema("{\"type\":\"string\", \"title\":\"Author\", pattern: \"^[a-zA-Z]+$\"}")
 *             .serviceName("contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:MetadataSchema author /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/metadataSchemas/{metadataSchemaName}
 * ```
 * @property assignedTo The assignees
 * @property metadataSchemaName The name of the metadata schema.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schema The schema defining the type.
 * @property serviceName The name of Azure API Center service.
 */
public data class MetadataSchemaArgs(
    public val assignedTo: Output<List<MetadataAssignmentArgs>>? = null,
    public val metadataSchemaName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schema: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.MetadataSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.MetadataSchemaArgs =
        com.pulumi.azurenative.apicenter.MetadataSchemaArgs.builder()
            .assignedTo(
                assignedTo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metadataSchemaName(metadataSchemaName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetadataSchemaArgs].
 */
@PulumiTagMarker
public class MetadataSchemaArgsBuilder internal constructor() {
    private var assignedTo: Output<List<MetadataAssignmentArgs>>? = null

    private var metadataSchemaName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schema: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The assignees
     */
    @JvmName("vdwtnkpdfyygbxqe")
    public suspend fun assignedTo(`value`: Output<List<MetadataAssignmentArgs>>) {
        this.assignedTo = value
    }

    @JvmName("ntlsdrckocslbckq")
    public suspend fun assignedTo(vararg values: Output<MetadataAssignmentArgs>) {
        this.assignedTo = Output.all(values.asList())
    }

    /**
     * @param values The assignees
     */
    @JvmName("thubxcdohuigcgvm")
    public suspend fun assignedTo(values: List<Output<MetadataAssignmentArgs>>) {
        this.assignedTo = Output.all(values)
    }

    /**
     * @param value The name of the metadata schema.
     */
    @JvmName("blqdmustowhydnvi")
    public suspend fun metadataSchemaName(`value`: Output<String>) {
        this.metadataSchemaName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("smvcledagjfywugl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The schema defining the type.
     */
    @JvmName("nptxtqvgkcxtmfgl")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("xsjyebrxawwplxxi")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The assignees
     */
    @JvmName("vjufwpfkllpvhwdh")
    public suspend fun assignedTo(`value`: List<MetadataAssignmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedTo = mapped
    }

    /**
     * @param argument The assignees
     */
    @JvmName("xarapaegykoppjbm")
    public suspend fun assignedTo(argument: List<suspend MetadataAssignmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetadataAssignmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.assignedTo = mapped
    }

    /**
     * @param argument The assignees
     */
    @JvmName("uhewkbnrsbafqtru")
    public suspend fun assignedTo(vararg argument: suspend MetadataAssignmentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetadataAssignmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.assignedTo = mapped
    }

    /**
     * @param argument The assignees
     */
    @JvmName("rklglysmngsfcgir")
    public suspend fun assignedTo(argument: suspend MetadataAssignmentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetadataAssignmentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.assignedTo = mapped
    }

    /**
     * @param values The assignees
     */
    @JvmName("jdoooqehfjcdsyrq")
    public suspend fun assignedTo(vararg values: MetadataAssignmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignedTo = mapped
    }

    /**
     * @param value The name of the metadata schema.
     */
    @JvmName("ojwcemnfqfnlpmgs")
    public suspend fun metadataSchemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataSchemaName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oavyfuklfndrlygl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The schema defining the type.
     */
    @JvmName("ixgkdghvwrnedgxa")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("wlhgtfwvqimxhsjg")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): MetadataSchemaArgs = MetadataSchemaArgs(
        assignedTo = assignedTo,
        metadataSchemaName = metadataSchemaName,
        resourceGroupName = resourceGroupName,
        schema = schema,
        serviceName = serviceName,
    )
}
