@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.DeploymentServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Server
 * @property runtimeUri Base runtime URLs for this deployment.
 */
public data class DeploymentServerArgs(
    public val runtimeUri: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.DeploymentServerArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.DeploymentServerArgs =
        com.pulumi.azurenative.apicenter.inputs.DeploymentServerArgs.builder()
            .runtimeUri(runtimeUri?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DeploymentServerArgs].
 */
@PulumiTagMarker
public class DeploymentServerArgsBuilder internal constructor() {
    private var runtimeUri: Output<List<String>>? = null

    /**
     * @param value Base runtime URLs for this deployment.
     */
    @JvmName("dydhksjujdemrwyd")
    public suspend fun runtimeUri(`value`: Output<List<String>>) {
        this.runtimeUri = value
    }

    @JvmName("jikwfkjcwowjxaon")
    public suspend fun runtimeUri(vararg values: Output<String>) {
        this.runtimeUri = Output.all(values.asList())
    }

    /**
     * @param values Base runtime URLs for this deployment.
     */
    @JvmName("rgklgwgjkdeosksf")
    public suspend fun runtimeUri(values: List<Output<String>>) {
        this.runtimeUri = Output.all(values)
    }

    /**
     * @param value Base runtime URLs for this deployment.
     */
    @JvmName("ayakjhobrqtsuila")
    public suspend fun runtimeUri(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeUri = mapped
    }

    /**
     * @param values Base runtime URLs for this deployment.
     */
    @JvmName("gtsbgdmejgcxtuqb")
    public suspend fun runtimeUri(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtimeUri = mapped
    }

    internal fun build(): DeploymentServerArgs = DeploymentServerArgs(
        runtimeUri = runtimeUri,
    )
}
