@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.GetApiDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiName The name of the API.
 * @property definitionName The name of the API definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property versionName The name of the API version.
 * @property workspaceName The name of the workspace.
 */
public data class GetApiDefinitionPlainArgs(
    public val apiName: String,
    public val definitionName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val versionName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.GetApiDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.GetApiDefinitionPlainArgs =
        com.pulumi.azurenative.apicenter.inputs.GetApiDefinitionPlainArgs.builder()
            .apiName(apiName.let({ args0 -> args0 }))
            .definitionName(definitionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .versionName(versionName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetApiDefinitionPlainArgsBuilder internal constructor() {
    private var apiName: String? = null

    private var definitionName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var versionName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("dsyhewhjdjuyqnwk")
    public suspend fun apiName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiName = mapped
    }

    /**
     * @param value The name of the API definition.
     */
    @JvmName("wibtoylbebrssvcv")
    public suspend fun definitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.definitionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fkjwwysccvkgdrcw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("ubxnbrjxljlxgpgm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the API version.
     */
    @JvmName("bpflaggkqxaydjmc")
    public suspend fun versionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("tqgainsllsqajwtp")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetApiDefinitionPlainArgs = GetApiDefinitionPlainArgs(
        apiName = apiName ?: throw PulumiNullFieldException("apiName"),
        definitionName = definitionName ?: throw PulumiNullFieldException("definitionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        versionName = versionName ?: throw PulumiNullFieldException("versionName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
