@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.GetApiPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiName The name of the API.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property workspaceName The name of the workspace.
 */
public data class GetApiPlainArgs(
    public val apiName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.GetApiPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.GetApiPlainArgs =
        com.pulumi.azurenative.apicenter.inputs.GetApiPlainArgs.builder()
            .apiName(apiName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiPlainArgs].
 */
@PulumiTagMarker
public class GetApiPlainArgsBuilder internal constructor() {
    private var apiName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("mislobnhuijonbgh")
    public suspend fun apiName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tfidhalewvpiffvh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("grsgtvotroksojlp")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ujiyhgnmoutcoyta")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetApiPlainArgs = GetApiPlainArgs(
        apiName = apiName ?: throw PulumiNullFieldException("apiName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
