@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.GetEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName The name of the environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property workspaceName The name of the workspace.
 */
public data class GetEnvironmentPlainArgs(
    public val environmentName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.GetEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.GetEnvironmentPlainArgs =
        com.pulumi.azurenative.apicenter.inputs.GetEnvironmentPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the environment.
     */
    @JvmName("gwoelkealyumimfa")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qrsqargiulhsmqah")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("hwqcpmurpmvakfob")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pglqdivgcxrarctg")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetEnvironmentPlainArgs = GetEnvironmentPlainArgs(
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
