@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.TermsOfServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Terms of service for the API.
 * @property url URL pointing to the terms of service.
 */
public data class TermsOfServiceArgs(
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.TermsOfServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.TermsOfServiceArgs =
        com.pulumi.azurenative.apicenter.inputs.TermsOfServiceArgs.builder()
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TermsOfServiceArgs].
 */
@PulumiTagMarker
public class TermsOfServiceArgsBuilder internal constructor() {
    private var url: Output<String>? = null

    /**
     * @param value URL pointing to the terms of service.
     */
    @JvmName("shijiydqccionuji")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value URL pointing to the terms of service.
     */
    @JvmName("ihybtvgcsimovfrf")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): TermsOfServiceArgs = TermsOfServiceArgs(
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
