@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Server information of the environment.
 * @property managementPortalUri The location of the management portal
 * @property type Type of the server that represents the environment.
 */
public data class EnvironmentServerResponse(
    public val managementPortalUri: List<String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.EnvironmentServerResponse):
            EnvironmentServerResponse = EnvironmentServerResponse(
            managementPortalUri = javaType.managementPortalUri().map({ args0 -> args0 }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
