@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Additional, external documentation for the API.
 * @property description Description of the documentation.
 * @property title Title of the documentation.
 * @property url URL pointing to the documentation.
 */
public data class ExternalDocumentationResponse(
    public val description: String? = null,
    public val title: String? = null,
    public val url: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.ExternalDocumentationResponse):
            ExternalDocumentationResponse = ExternalDocumentationResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            url = javaType.url(),
        )
    }
}
