@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * API deployment entity.
 * @property customProperties The custom metadata defined for API catalog entities.
 * @property definitionId API center-scoped definition resource ID.
 * @property description Description of the deployment.
 * @property environmentId API center-scoped environment resource ID.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property server The deployment server
 * @property state State of API deployment.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property title API deployment title
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDeploymentResult(
    public val customProperties: Any? = null,
    public val definitionId: String? = null,
    public val description: String? = null,
    public val environmentId: String? = null,
    public val id: String,
    public val name: String,
    public val server: DeploymentServerResponse? = null,
    public val state: String? = null,
    public val systemData: SystemDataResponse,
    public val title: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.GetDeploymentResult):
            GetDeploymentResult = GetDeploymentResult(
            customProperties = javaType.customProperties().map({ args0 -> args0 }).orElse(null),
            definitionId = javaType.definitionId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            server = javaType.server().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.DeploymentServerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
