@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.RequestContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ResponseContractResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse.Companion.toKotlin as parameterContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.RequestContractResponse.Companion.toKotlin as requestContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ResponseContractResponse.Companion.toKotlin as responseContractResponseToKotlin

/**
 * Builder for [ApiOperation].
 */
@PulumiTagMarker
public class ApiOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiOperationArgs = ApiOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiOperationArgsBuilder.() -> Unit) {
        val builder = ApiOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiOperation {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ApiOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApiOperation(builtJavaResource)
    }
}

/**
 * API Operation details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiOperation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiOperation = new AzureNative.ApiManagement.ApiOperation("apiOperation", new()
 *     {
 *         ApiId = "PetStoreTemplate2",
 *         Description = "This can only be done by the logged in user.",
 *         DisplayName = "createUser2",
 *         Method = "POST",
 *         OperationId = "newoperations",
 *         Request = new AzureNative.ApiManagement.Inputs.RequestContractArgs
 *         {
 *             Description = "Created user object",
 *             Headers = new() { },
 *             QueryParameters = new() { },
 *             Representations = new[]
 *             {
 *                 new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                 {
 *                     ContentType = "application/json",
 *                     SchemaId = "592f6c1d0af5840ca8897f0c",
 *                     TypeName = "User",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Responses = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.ResponseContractArgs
 *             {
 *                 Description = "successful operation",
 *                 Headers = new[] {},
 *                 Representations = new[]
 *                 {
 *                     new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                     {
 *                         ContentType = "application/xml",
 *                     },
 *                     new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                     {
 *                         ContentType = "application/json",
 *                     },
 *                 },
 *                 StatusCode = 200,
 *             },
 *         },
 *         ServiceName = "apimService1",
 *         TemplateParameters = new[] {},
 *         UrlTemplate = "/user1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiOperation(ctx, "apiOperation", &apimanagement.ApiOperationArgs{
 * 			ApiId:       pulumi.String("PetStoreTemplate2"),
 * 			Description: pulumi.String("This can only be done by the logged in user."),
 * 			DisplayName: pulumi.String("createUser2"),
 * 			Method:      pulumi.String("POST"),
 * 			OperationId: pulumi.String("newoperations"),
 * 			Request: apimanagement.RequestContractResponse{
 * 				Description:     pulumi.String("Created user object"),
 * 				Headers:         apimanagement.ParameterContractArray{},
 * 				QueryParameters: apimanagement.ParameterContractArray{},
 * 				Representations: apimanagement.RepresentationContractArray{
 * 					&apimanagement.RepresentationContractArgs{
 * 						ContentType: pulumi.String("application/json"),
 * 						SchemaId:    pulumi.String("592f6c1d0af5840ca8897f0c"),
 * 						TypeName:    pulumi.String("User"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Responses: []apimanagement.ResponseContractArgs{
 * 				{
 * 					Description: pulumi.String("successful operation"),
 * 					Headers:     apimanagement.ParameterContractArray{},
 * 					Representations: apimanagement.RepresentationContractArray{
 * 						{
 * 							ContentType: pulumi.String("application/xml"),
 * 						},
 * 						{
 * 							ContentType: pulumi.String("application/json"),
 * 						},
 * 					},
 * 					StatusCode: pulumi.Int(200),
 * 				},
 * 			},
 * 			ServiceName:        pulumi.String("apimService1"),
 * 			TemplateParameters: apimanagement.ParameterContractArray{},
 * 			UrlTemplate:        pulumi.String("/user1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiOperation;
 * import com.pulumi.azurenative.apimanagement.ApiOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiOperation = new ApiOperation("apiOperation", ApiOperationArgs.builder()
 *             .apiId("PetStoreTemplate2")
 *             .description("This can only be done by the logged in user.")
 *             .displayName("createUser2")
 *             .method("POST")
 *             .operationId("newoperations")
 *             .request(Map.ofEntries(
 *                 Map.entry("description", "Created user object"),
 *                 Map.entry("headers", ),
 *                 Map.entry("queryParameters", ),
 *                 Map.entry("representations", Map.ofEntries(
 *                     Map.entry("contentType", "application/json"),
 *                     Map.entry("schemaId", "592f6c1d0af5840ca8897f0c"),
 *                     Map.entry("typeName", "User")
 *                 ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .responses(Map.ofEntries(
 *                 Map.entry("description", "successful operation"),
 *                 Map.entry("headers", ),
 *                 Map.entry("representations",
 *                     Map.of("contentType", "application/xml"),
 *                     Map.of("contentType", "application/json")),
 *                 Map.entry("statusCode", 200)
 *             ))
 *             .serviceName("apimService1")
 *             .templateParameters()
 *             .urlTemplate("/user1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiOperation newoperations /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}
 * ```
 */
public class ApiOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiOperation,
) : KotlinCustomResource(javaResource, ApiOperationMapper) {
    /**
     * Description of the operation. May include HTML formatting tags.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operation Name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
     */
    public val method: Output<String>
        get() = javaResource.method().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operation Policies
     */
    public val policies: Output<String>?
        get() = javaResource.policies().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An entity containing request details.
     */
    public val request: Output<RequestContractResponse>?
        get() = javaResource.request().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    requestContractResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Array of Operation responses.
     */
    public val responses: Output<List<ResponseContractResponse>>?
        get() = javaResource.responses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> responseContractResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Collection of URL template parameters.
     */
    public val templateParameters: Output<List<ParameterContractResponse>>?
        get() = javaResource.templateParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        parameterContractResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
     */
    public val urlTemplate: Output<String>
        get() = javaResource.urlTemplate().applyValue({ args0 -> args0 })
}

public object ApiOperationMapper : ResourceMapper<ApiOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiOperation::class == javaResource::class

    override fun map(javaResource: Resource): ApiOperation = ApiOperation(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiOperation,
    )
}

/**
 * @see [ApiOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiOperation].
 */
public suspend fun apiOperation(
    name: String,
    block: suspend ApiOperationResourceBuilder.() -> Unit,
): ApiOperation {
    val builder = ApiOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiOperation(name: String): ApiOperation {
    val builder = ApiOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
