@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiVersionSetArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.VersioningScheme
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API Version Set Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiVersionSet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiVersionSet = new AzureNative.ApiManagement.ApiVersionSet("apiVersionSet", new()
 *     {
 *         Description = "Version configuration",
 *         DisplayName = "api set 1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         VersionSetId = "api1",
 *         VersioningScheme = "Segment",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiVersionSet(ctx, "apiVersionSet", &apimanagement.ApiVersionSetArgs{
 * 			Description:       pulumi.String("Version configuration"),
 * 			DisplayName:       pulumi.String("api set 1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			VersionSetId:      pulumi.String("api1"),
 * 			VersioningScheme:  pulumi.String("Segment"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiVersionSet;
 * import com.pulumi.azurenative.apimanagement.ApiVersionSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiVersionSet = new ApiVersionSet("apiVersionSet", ApiVersionSetArgs.builder()
 *             .description("Version configuration")
 *             .displayName("api set 1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .versionSetId("api1")
 *             .versioningScheme("Segment")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiVersionSet api1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apiVersionSets/{versionSetId}
 * ```
 * @property description Description of API Version Set.
 * @property displayName Name of API Version Set
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property versionHeaderName Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
 * @property versionQueryName Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
 * @property versionSetId Api Version Set identifier. Must be unique in the current API Management service instance.
 * @property versioningScheme An value that determines where the API Version identifier will be located in a HTTP request.
 */
public data class ApiVersionSetArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val versionHeaderName: Output<String>? = null,
    public val versionQueryName: Output<String>? = null,
    public val versionSetId: Output<String>? = null,
    public val versioningScheme: Output<Either<String, VersioningScheme>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiVersionSetArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiVersionSetArgs =
        com.pulumi.azurenative.apimanagement.ApiVersionSetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .versionHeaderName(versionHeaderName?.applyValue({ args0 -> args0 }))
            .versionQueryName(versionQueryName?.applyValue({ args0 -> args0 }))
            .versionSetId(versionSetId?.applyValue({ args0 -> args0 }))
            .versioningScheme(
                versioningScheme?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ApiVersionSetArgs].
 */
@PulumiTagMarker
public class ApiVersionSetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var versionHeaderName: Output<String>? = null

    private var versionQueryName: Output<String>? = null

    private var versionSetId: Output<String>? = null

    private var versioningScheme: Output<Either<String, VersioningScheme>>? = null

    /**
     * @param value Description of API Version Set.
     */
    @JvmName("jbjevtoxwsdkfuxy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of API Version Set
     */
    @JvmName("ljsgfdpovhnghlqe")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wjybgerwtvgbxxgj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jmybmfgeyojdqftg")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
     */
    @JvmName("dhmjlrnnrlwncvsq")
    public suspend fun versionHeaderName(`value`: Output<String>) {
        this.versionHeaderName = value
    }

    /**
     * @param value Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
     */
    @JvmName("ybvwtvhojqkasryk")
    public suspend fun versionQueryName(`value`: Output<String>) {
        this.versionQueryName = value
    }

    /**
     * @param value Api Version Set identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("doesnypgvqiyjxac")
    public suspend fun versionSetId(`value`: Output<String>) {
        this.versionSetId = value
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("wegdgkhhkdamqqrk")
    public suspend fun versioningScheme(`value`: Output<Either<String, VersioningScheme>>) {
        this.versioningScheme = value
    }

    /**
     * @param value Description of API Version Set.
     */
    @JvmName("shpciholtgvjydxn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of API Version Set
     */
    @JvmName("umnrwoukisivputw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("adbublrrrxkexqcc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vapheqmgbjrqvjdq")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
     */
    @JvmName("mrubxjthxwsrtmgg")
    public suspend fun versionHeaderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionHeaderName = mapped
    }

    /**
     * @param value Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
     */
    @JvmName("wjifnneldmbjkkua")
    public suspend fun versionQueryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionQueryName = mapped
    }

    /**
     * @param value Api Version Set identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jqisedxqpqjvjtsb")
    public suspend fun versionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionSetId = mapped
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("cdikkfjjsobolmnp")
    public suspend fun versioningScheme(`value`: Either<String, VersioningScheme>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versioningScheme = mapped
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("xmffkknynhofmijv")
    public fun versioningScheme(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VersioningScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versioningScheme = mapped
    }

    /**
     * @param value An value that determines where the API Version identifier will be located in a HTTP request.
     */
    @JvmName("mlgnrskpcakpeqts")
    public fun versioningScheme(`value`: VersioningScheme) {
        val toBeMapped = Either.ofRight<String, VersioningScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versioningScheme = mapped
    }

    internal fun build(): ApiVersionSetArgs = ApiVersionSetArgs(
        description = description,
        displayName = displayName,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        versionHeaderName = versionHeaderName,
        versionQueryName = versionQueryName,
        versionSetId = versionSetId,
        versioningScheme = versioningScheme,
    )
}
