@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.AuthorizationArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.AuthorizationType
import com.pulumi.azurenative.apimanagement.kotlin.enums.OAuth2GrantType
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthorizationErrorArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthorizationErrorArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Authorization contract.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAuthorizationAADAuthCode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorization = new AzureNative.ApiManagement.Authorization("authorization", new()
 *     {
 *         AuthorizationId = "authz2",
 *         AuthorizationProviderId = "aadwithauthcode",
 *         AuthorizationType = "OAuth2",
 *         OAuth2GrantType = "AuthorizationCode",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorization(ctx, "authorization", &apimanagement.AuthorizationArgs{
 * 			AuthorizationId:         pulumi.String("authz2"),
 * 			AuthorizationProviderId: pulumi.String("aadwithauthcode"),
 * 			AuthorizationType:       pulumi.String("OAuth2"),
 * 			OAuth2GrantType:         pulumi.String("AuthorizationCode"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			ServiceName:             pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Authorization;
 * import com.pulumi.azurenative.apimanagement.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorization = new Authorization("authorization", AuthorizationArgs.builder()
 *             .authorizationId("authz2")
 *             .authorizationProviderId("aadwithauthcode")
 *             .authorizationType("OAuth2")
 *             .oAuth2GrantType("AuthorizationCode")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationAADClientCred
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorization = new AzureNative.ApiManagement.Authorization("authorization", new()
 *     {
 *         AuthorizationId = "authz1",
 *         AuthorizationProviderId = "aadwithclientcred",
 *         AuthorizationType = "OAuth2",
 *         OAuth2GrantType = "AuthorizationCode",
 *         Parameters =
 *         {
 *             { "clientId", "53790925-fdd3-4b80-bc7a-4c3aaf25801d" },
 *             { "clientSecret", "FcJkQ3iPSaKAQRA7Ft8Q~fZ1X5vKmqzUAfJagcJ8" },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorization(ctx, "authorization", &apimanagement.AuthorizationArgs{
 * 			AuthorizationId:         pulumi.String("authz1"),
 * 			AuthorizationProviderId: pulumi.String("aadwithclientcred"),
 * 			AuthorizationType:       pulumi.String("OAuth2"),
 * 			OAuth2GrantType:         pulumi.String("AuthorizationCode"),
 * 			Parameters: pulumi.StringMap{
 * 				"clientId":     pulumi.String("53790925-fdd3-4b80-bc7a-4c3aaf25801d"),
 * 				"clientSecret": pulumi.String("FcJkQ3iPSaKAQRA7Ft8Q~fZ1X5vKmqzUAfJagcJ8"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Authorization;
 * import com.pulumi.azurenative.apimanagement.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorization = new Authorization("authorization", AuthorizationArgs.builder()
 *             .authorizationId("authz1")
 *             .authorizationProviderId("aadwithclientcred")
 *             .authorizationType("OAuth2")
 *             .oAuth2GrantType("AuthorizationCode")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("clientId", "53790925-fdd3-4b80-bc7a-4c3aaf25801d"),
 *                 Map.entry("clientSecret", "FcJkQ3iPSaKAQRA7Ft8Q~fZ1X5vKmqzUAfJagcJ8")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Authorization authz1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}
 * ```
 * @property authorizationId Identifier of the authorization.
 * @property authorizationProviderId Identifier of the authorization provider.
 * @property authorizationType Authorization type options
 * @property error Authorization error details.
 * @property oAuth2GrantType OAuth2 grant type options
 * @property parameters Authorization parameters
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property status Status of the Authorization
 */
public data class AuthorizationArgs(
    public val authorizationId: Output<String>? = null,
    public val authorizationProviderId: Output<String>? = null,
    public val authorizationType: Output<Either<String, AuthorizationType>>? = null,
    public val error: Output<AuthorizationErrorArgs>? = null,
    public val oAuth2GrantType: Output<Either<String, OAuth2GrantType>>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.AuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.AuthorizationArgs =
        com.pulumi.azurenative.apimanagement.AuthorizationArgs.builder()
            .authorizationId(authorizationId?.applyValue({ args0 -> args0 }))
            .authorizationProviderId(authorizationProviderId?.applyValue({ args0 -> args0 }))
            .authorizationType(
                authorizationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .error(error?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .oAuth2GrantType(
                oAuth2GrantType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationArgs].
 */
@PulumiTagMarker
public class AuthorizationArgsBuilder internal constructor() {
    private var authorizationId: Output<String>? = null

    private var authorizationProviderId: Output<String>? = null

    private var authorizationType: Output<Either<String, AuthorizationType>>? = null

    private var error: Output<AuthorizationErrorArgs>? = null

    private var oAuth2GrantType: Output<Either<String, OAuth2GrantType>>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Identifier of the authorization.
     */
    @JvmName("hfwaajdiuajlrdom")
    public suspend fun authorizationId(`value`: Output<String>) {
        this.authorizationId = value
    }

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("fmdlkhvlmdauiiqe")
    public suspend fun authorizationProviderId(`value`: Output<String>) {
        this.authorizationProviderId = value
    }

    /**
     * @param value Authorization type options
     */
    @JvmName("oulitnlynkudipjm")
    public suspend fun authorizationType(`value`: Output<Either<String, AuthorizationType>>) {
        this.authorizationType = value
    }

    /**
     * @param value Authorization error details.
     */
    @JvmName("xypkqtnlxfsckvwy")
    public suspend fun error(`value`: Output<AuthorizationErrorArgs>) {
        this.error = value
    }

    /**
     * @param value OAuth2 grant type options
     */
    @JvmName("vjegxovkbgqbrnpy")
    public suspend fun oAuth2GrantType(`value`: Output<Either<String, OAuth2GrantType>>) {
        this.oAuth2GrantType = value
    }

    /**
     * @param value Authorization parameters
     */
    @JvmName("ousdeoahlsrlklcg")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lmhavnfcmixamvid")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ncddclhwirgbhxmq")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Status of the Authorization
     */
    @JvmName("giayjokhrfrskdpm")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Identifier of the authorization.
     */
    @JvmName("gwhnatwyrkptghde")
    public suspend fun authorizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationId = mapped
    }

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("mqcifwfhtlssbihu")
    public suspend fun authorizationProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationProviderId = mapped
    }

    /**
     * @param value Authorization type options
     */
    @JvmName("sqbssllpwxymfkyp")
    public suspend fun authorizationType(`value`: Either<String, AuthorizationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Authorization type options
     */
    @JvmName("kinawygjitjpsnnt")
    public fun authorizationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthorizationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Authorization type options
     */
    @JvmName("ddroiodyrckjympe")
    public fun authorizationType(`value`: AuthorizationType) {
        val toBeMapped = Either.ofRight<String, AuthorizationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Authorization error details.
     */
    @JvmName("esjxeaxekkprmtgw")
    public suspend fun error(`value`: AuthorizationErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param argument Authorization error details.
     */
    @JvmName("pmnsogqnehlhxjnu")
    public suspend fun error(argument: suspend AuthorizationErrorArgsBuilder.() -> Unit) {
        val toBeMapped = AuthorizationErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.error = mapped
    }

    /**
     * @param value OAuth2 grant type options
     */
    @JvmName("npupjjjftqixedma")
    public suspend fun oAuth2GrantType(`value`: Either<String, OAuth2GrantType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oAuth2GrantType = mapped
    }

    /**
     * @param value OAuth2 grant type options
     */
    @JvmName("qclpfrvsoyasniav")
    public fun oAuth2GrantType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OAuth2GrantType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oAuth2GrantType = mapped
    }

    /**
     * @param value OAuth2 grant type options
     */
    @JvmName("byiwscsnnuxdmujs")
    public fun oAuth2GrantType(`value`: OAuth2GrantType) {
        val toBeMapped = Either.ofRight<String, OAuth2GrantType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oAuth2GrantType = mapped
    }

    /**
     * @param value Authorization parameters
     */
    @JvmName("ovhfdrfbnshoeego")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Authorization parameters
     */
    @JvmName("lxkmrkpnmikyeldj")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("swilyorhhllrfrfr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qkwkfrvqudrgjecd")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Status of the Authorization
     */
    @JvmName("nyqvydgpjmeccjrl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): AuthorizationArgs = AuthorizationArgs(
        authorizationId = authorizationId,
        authorizationProviderId = authorizationProviderId,
        authorizationType = authorizationType,
        error = error,
        oAuth2GrantType = oAuth2GrantType,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        status = status,
    )
}
