@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthorizationProviderOAuth2SettingsResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthorizationProviderOAuth2SettingsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AuthorizationProvider].
 */
@PulumiTagMarker
public class AuthorizationProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizationProviderArgs = AuthorizationProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizationProviderArgsBuilder.() -> Unit) {
        val builder = AuthorizationProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AuthorizationProvider {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.AuthorizationProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AuthorizationProvider(builtJavaResource)
    }
}

/**
 * Authorization Provider contract.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAuthorizationProviderAADAuthCode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "aadwithauthcode",
 *         DisplayName = "aadwithauthcode",
 *         IdentityProvider = "aad",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "clientId", "59790825-fdd3-4b10-bc7a-4c3aaf25801d" },
 *                     { "clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8" },
 *                     { "resourceUri", "https://graph.microsoft.com" },
 *                     { "scopes", "User.Read.All Group.Read.All" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("aadwithauthcode"),
 * 			DisplayName:             pulumi.String("aadwithauthcode"),
 * 			IdentityProvider:        pulumi.String("aad"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"clientId":     pulumi.String("59790825-fdd3-4b10-bc7a-4c3aaf25801d"),
 * 						"clientSecret": pulumi.String("Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 * 						"resourceUri":  pulumi.String("https://graph.microsoft.com"),
 * 						"scopes":       pulumi.String("User.Read.All Group.Read.All"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("aadwithauthcode")
 *             .displayName("aadwithauthcode")
 *             .identityProvider("aad")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("clientId", "59790825-fdd3-4b10-bc7a-4c3aaf25801d"),
 *                     Map.entry("clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 *                     Map.entry("resourceUri", "https://graph.microsoft.com"),
 *                     Map.entry("scopes", "User.Read.All Group.Read.All")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationProviderAADClientCred
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "aadwithclientcred",
 *         DisplayName = "aadwithclientcred",
 *         IdentityProvider = "aad",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "resourceUri", "https://graph.microsoft.com" },
 *                     { "scopes", "User.Read.All Group.Read.All" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("aadwithclientcred"),
 * 			DisplayName:             pulumi.String("aadwithclientcred"),
 * 			IdentityProvider:        pulumi.String("aad"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"resourceUri": pulumi.String("https://graph.microsoft.com"),
 * 						"scopes":      pulumi.String("User.Read.All Group.Read.All"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("aadwithclientcred")
 *             .displayName("aadwithclientcred")
 *             .identityProvider("aad")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("resourceUri", "https://graph.microsoft.com"),
 *                     Map.entry("scopes", "User.Read.All Group.Read.All")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationProviderGenericOAuth2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "eventbrite",
 *         DisplayName = "eventbrite",
 *         IdentityProvider = "oauth2",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "authorizationUrl", "https://www.eventbrite.com/oauth/authorize" },
 *                     { "clientId", "ZYIJTBTABHOUQQDLZY" },
 *                     { "clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8" },
 *                     { "refreshUrl", "https://www.eventbrite.com/oauth/token" },
 *                     { "scopes", "" },
 *                     { "tokenUrl", "https://www.eventbrite.com/oauth/token" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("eventbrite"),
 * 			DisplayName:             pulumi.String("eventbrite"),
 * 			IdentityProvider:        pulumi.String("oauth2"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"authorizationUrl": pulumi.String("https://www.eventbrite.com/oauth/authorize"),
 * 						"clientId":         pulumi.String("ZYIJTBTABHOUQQDLZY"),
 * 						"clientSecret":     pulumi.String("Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 * 						"refreshUrl":       pulumi.String("https://www.eventbrite.com/oauth/token"),
 * 						"scopes":           pulumi.String(""),
 * 						"tokenUrl":         pulumi.String("https://www.eventbrite.com/oauth/token"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("eventbrite")
 *             .displayName("eventbrite")
 *             .identityProvider("oauth2")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("authorizationUrl", "https://www.eventbrite.com/oauth/authorize"),
 *                     Map.entry("clientId", "ZYIJTBTABHOUQQDLZY"),
 *                     Map.entry("clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 *                     Map.entry("refreshUrl", "https://www.eventbrite.com/oauth/token"),
 *                     Map.entry("scopes", ""),
 *                     Map.entry("tokenUrl", "https://www.eventbrite.com/oauth/token")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationProviderOOBGoogle
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "google",
 *         DisplayName = "google",
 *         IdentityProvider = "google",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "clientId", "508791967882-5qv6o2i99a75un7329vlegtk78kr766h.apps.googleusercontent.com" },
 *                     { "clientSecret", "qDN0VyVFjU1OsOyT5Kz8ce" },
 *                     { "scopes", "openid https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("google"),
 * 			DisplayName:             pulumi.String("google"),
 * 			IdentityProvider:        pulumi.String("google"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"clientId":     pulumi.String("508791967882-5qv6o2i99a75un7329vlegtk78kr766h.apps.googleusercontent.com"),
 * 						"clientSecret": pulumi.String("qDN0VyVFjU1OsOyT5Kz8ce"),
 * 						"scopes":       pulumi.String("openid https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("google")
 *             .displayName("google")
 *             .identityProvider("google")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("clientId", "508791967882-5qv6o2i99a75un7329vlegtk78kr766h.apps.googleusercontent.com"),
 *                     Map.entry("clientSecret", "qDN0VyVFjU1OsOyT5Kz8ce"),
 *                     Map.entry("scopes", "openid https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:AuthorizationProvider google /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}
 * ```
 */
public class AuthorizationProvider internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.AuthorizationProvider,
) : KotlinCustomResource(javaResource, AuthorizationProviderMapper) {
    /**
     * Authorization Provider name. Must be 1 to 300 characters long.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identity provider name. Must be 1 to 300 characters long.
     */
    public val identityProvider: Output<String>?
        get() = javaResource.identityProvider().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * OAuth2 settings
     */
    public val oauth2: Output<AuthorizationProviderOAuth2SettingsResponse>?
        get() = javaResource.oauth2().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AuthorizationProviderMapper : ResourceMapper<AuthorizationProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.AuthorizationProvider::class == javaResource::class

    override fun map(javaResource: Resource): AuthorizationProvider =
        AuthorizationProvider(
            javaResource as
                com.pulumi.azurenative.apimanagement.AuthorizationProvider,
        )
}

/**
 * @see [AuthorizationProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuthorizationProvider].
 */
public suspend fun authorizationProvider(
    name: String,
    block: suspend AuthorizationProviderResourceBuilder.() -> Unit,
): AuthorizationProvider {
    val builder = AuthorizationProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuthorizationProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorizationProvider(name: String): AuthorizationProvider {
    val builder = AuthorizationProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
