@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthorizationProviderOAuth2SettingsArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthorizationProviderOAuth2SettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Authorization Provider contract.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAuthorizationProviderAADAuthCode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "aadwithauthcode",
 *         DisplayName = "aadwithauthcode",
 *         IdentityProvider = "aad",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "clientId", "59790825-fdd3-4b10-bc7a-4c3aaf25801d" },
 *                     { "clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8" },
 *                     { "resourceUri", "https://graph.microsoft.com" },
 *                     { "scopes", "User.Read.All Group.Read.All" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("aadwithauthcode"),
 * 			DisplayName:             pulumi.String("aadwithauthcode"),
 * 			IdentityProvider:        pulumi.String("aad"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"clientId":     pulumi.String("59790825-fdd3-4b10-bc7a-4c3aaf25801d"),
 * 						"clientSecret": pulumi.String("Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 * 						"resourceUri":  pulumi.String("https://graph.microsoft.com"),
 * 						"scopes":       pulumi.String("User.Read.All Group.Read.All"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("aadwithauthcode")
 *             .displayName("aadwithauthcode")
 *             .identityProvider("aad")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("clientId", "59790825-fdd3-4b10-bc7a-4c3aaf25801d"),
 *                     Map.entry("clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 *                     Map.entry("resourceUri", "https://graph.microsoft.com"),
 *                     Map.entry("scopes", "User.Read.All Group.Read.All")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationProviderAADClientCred
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "aadwithclientcred",
 *         DisplayName = "aadwithclientcred",
 *         IdentityProvider = "aad",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "resourceUri", "https://graph.microsoft.com" },
 *                     { "scopes", "User.Read.All Group.Read.All" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("aadwithclientcred"),
 * 			DisplayName:             pulumi.String("aadwithclientcred"),
 * 			IdentityProvider:        pulumi.String("aad"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"resourceUri": pulumi.String("https://graph.microsoft.com"),
 * 						"scopes":      pulumi.String("User.Read.All Group.Read.All"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("aadwithclientcred")
 *             .displayName("aadwithclientcred")
 *             .identityProvider("aad")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("resourceUri", "https://graph.microsoft.com"),
 *                     Map.entry("scopes", "User.Read.All Group.Read.All")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationProviderGenericOAuth2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "eventbrite",
 *         DisplayName = "eventbrite",
 *         IdentityProvider = "oauth2",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "authorizationUrl", "https://www.eventbrite.com/oauth/authorize" },
 *                     { "clientId", "ZYIJTBTABHOUQQDLZY" },
 *                     { "clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8" },
 *                     { "refreshUrl", "https://www.eventbrite.com/oauth/token" },
 *                     { "scopes", "" },
 *                     { "tokenUrl", "https://www.eventbrite.com/oauth/token" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("eventbrite"),
 * 			DisplayName:             pulumi.String("eventbrite"),
 * 			IdentityProvider:        pulumi.String("oauth2"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"authorizationUrl": pulumi.String("https://www.eventbrite.com/oauth/authorize"),
 * 						"clientId":         pulumi.String("ZYIJTBTABHOUQQDLZY"),
 * 						"clientSecret":     pulumi.String("Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 * 						"refreshUrl":       pulumi.String("https://www.eventbrite.com/oauth/token"),
 * 						"scopes":           pulumi.String(""),
 * 						"tokenUrl":         pulumi.String("https://www.eventbrite.com/oauth/token"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("eventbrite")
 *             .displayName("eventbrite")
 *             .identityProvider("oauth2")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("authorizationUrl", "https://www.eventbrite.com/oauth/authorize"),
 *                     Map.entry("clientId", "ZYIJTBTABHOUQQDLZY"),
 *                     Map.entry("clientSecret", "Q3iPSaKQ~fZFcJk5vKmqzUAfJagcJ8"),
 *                     Map.entry("refreshUrl", "https://www.eventbrite.com/oauth/token"),
 *                     Map.entry("scopes", ""),
 *                     Map.entry("tokenUrl", "https://www.eventbrite.com/oauth/token")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateAuthorizationProviderOOBGoogle
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationProvider = new AzureNative.ApiManagement.AuthorizationProvider("authorizationProvider", new()
 *     {
 *         AuthorizationProviderId = "google",
 *         DisplayName = "google",
 *         IdentityProvider = "google",
 *         Oauth2 = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2SettingsArgs
 *         {
 *             GrantTypes = new AzureNative.ApiManagement.Inputs.AuthorizationProviderOAuth2GrantTypesArgs
 *             {
 *                 AuthorizationCode =
 *                 {
 *                     { "clientId", "508791967882-5qv6o2i99a75un7329vlegtk78kr766h.apps.googleusercontent.com" },
 *                     { "clientSecret", "qDN0VyVFjU1OsOyT5Kz8ce" },
 *                     { "scopes", "openid https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email" },
 *                 },
 *             },
 *             RedirectUrl = "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationProvider(ctx, "authorizationProvider", &apimanagement.AuthorizationProviderArgs{
 * 			AuthorizationProviderId: pulumi.String("google"),
 * 			DisplayName:             pulumi.String("google"),
 * 			IdentityProvider:        pulumi.String("google"),
 * 			Oauth2: apimanagement.AuthorizationProviderOAuth2SettingsResponse{
 * 				GrantTypes: &apimanagement.AuthorizationProviderOAuth2GrantTypesArgs{
 * 					AuthorizationCode: pulumi.StringMap{
 * 						"clientId":     pulumi.String("508791967882-5qv6o2i99a75un7329vlegtk78kr766h.apps.googleusercontent.com"),
 * 						"clientSecret": pulumi.String("qDN0VyVFjU1OsOyT5Kz8ce"),
 * 						"scopes":       pulumi.String("openid https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email"),
 * 					},
 * 				},
 * 				RedirectUrl: pulumi.String("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProvider;
 * import com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationProvider = new AuthorizationProvider("authorizationProvider", AuthorizationProviderArgs.builder()
 *             .authorizationProviderId("google")
 *             .displayName("google")
 *             .identityProvider("google")
 *             .oauth2(Map.ofEntries(
 *                 Map.entry("grantTypes", Map.of("authorizationCode", Map.ofEntries(
 *                     Map.entry("clientId", "508791967882-5qv6o2i99a75un7329vlegtk78kr766h.apps.googleusercontent.com"),
 *                     Map.entry("clientSecret", "qDN0VyVFjU1OsOyT5Kz8ce"),
 *                     Map.entry("scopes", "openid https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email")
 *                 ))),
 *                 Map.entry("redirectUrl", "https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:AuthorizationProvider google /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}
 * ```
 * @property authorizationProviderId Identifier of the authorization provider.
 * @property displayName Authorization Provider name. Must be 1 to 300 characters long.
 * @property identityProvider Identity provider name. Must be 1 to 300 characters long.
 * @property oauth2 OAuth2 settings
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class AuthorizationProviderArgs(
    public val authorizationProviderId: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val identityProvider: Output<String>? = null,
    public val oauth2: Output<AuthorizationProviderOAuth2SettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs =
        com.pulumi.azurenative.apimanagement.AuthorizationProviderArgs.builder()
            .authorizationProviderId(authorizationProviderId?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identityProvider(identityProvider?.applyValue({ args0 -> args0 }))
            .oauth2(oauth2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationProviderArgs].
 */
@PulumiTagMarker
public class AuthorizationProviderArgsBuilder internal constructor() {
    private var authorizationProviderId: Output<String>? = null

    private var displayName: Output<String>? = null

    private var identityProvider: Output<String>? = null

    private var oauth2: Output<AuthorizationProviderOAuth2SettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("jttxnjasxuehynqc")
    public suspend fun authorizationProviderId(`value`: Output<String>) {
        this.authorizationProviderId = value
    }

    /**
     * @param value Authorization Provider name. Must be 1 to 300 characters long.
     */
    @JvmName("spnwqplrqjeqsesp")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Identity provider name. Must be 1 to 300 characters long.
     */
    @JvmName("pmernhlgheclxary")
    public suspend fun identityProvider(`value`: Output<String>) {
        this.identityProvider = value
    }

    /**
     * @param value OAuth2 settings
     */
    @JvmName("vjiomcmicxmfcfgx")
    public suspend fun oauth2(`value`: Output<AuthorizationProviderOAuth2SettingsArgs>) {
        this.oauth2 = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eiprrqbbgisupack")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("arcffjbjlsamjbbs")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("hgauvmfiyjpqyjqk")
    public suspend fun authorizationProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationProviderId = mapped
    }

    /**
     * @param value Authorization Provider name. Must be 1 to 300 characters long.
     */
    @JvmName("vhulxcvanrpkjwyq")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Identity provider name. Must be 1 to 300 characters long.
     */
    @JvmName("vvtfvfgcdysmdvvn")
    public suspend fun identityProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProvider = mapped
    }

    /**
     * @param value OAuth2 settings
     */
    @JvmName("baoclkpllfheejmd")
    public suspend fun oauth2(`value`: AuthorizationProviderOAuth2SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauth2 = mapped
    }

    /**
     * @param argument OAuth2 settings
     */
    @JvmName("udpxufbkhxmtmrno")
    public suspend
    fun oauth2(argument: suspend AuthorizationProviderOAuth2SettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AuthorizationProviderOAuth2SettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.oauth2 = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("exnashdtlsbmbcni")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("yomrivqgepoismxe")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): AuthorizationProviderArgs = AuthorizationProviderArgs(
        authorizationProviderId = authorizationProviderId,
        displayName = displayName,
        identityProvider = identityProvider,
        oauth2 = oauth2,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
