@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.AuthorizationServerArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.AuthorizationMethod
import com.pulumi.azurenative.apimanagement.kotlin.enums.BearerTokenSendingMethod
import com.pulumi.azurenative.apimanagement.kotlin.enums.ClientAuthenticationMethod
import com.pulumi.azurenative.apimanagement.kotlin.enums.GrantType
import com.pulumi.azurenative.apimanagement.kotlin.inputs.TokenBodyParameterContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.TokenBodyParameterContractArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * External OAuth authorization server settings.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAuthorizationServer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationServer = new AzureNative.ApiManagement.AuthorizationServer("authorizationServer", new()
 *     {
 *         AuthorizationEndpoint = "https://www.contoso.com/oauth2/auth",
 *         AuthorizationMethods = new[]
 *         {
 *             AzureNative.ApiManagement.AuthorizationMethod.GET,
 *         },
 *         Authsid = "newauthServer",
 *         BearerTokenSendingMethods = new[]
 *         {
 *             "authorizationHeader",
 *         },
 *         ClientId = "1",
 *         ClientRegistrationEndpoint = "https://www.contoso.com/apps",
 *         ClientSecret = "2",
 *         DefaultScope = "read write",
 *         Description = "test server",
 *         DisplayName = "test2",
 *         GrantTypes = new[]
 *         {
 *             "authorizationCode",
 *             "implicit",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceOwnerPassword = "pwd",
 *         ResourceOwnerUsername = "un",
 *         ServiceName = "apimService1",
 *         SupportState = true,
 *         TokenEndpoint = "https://www.contoso.com/oauth2/token",
 *         UseInApiDocumentation = true,
 *         UseInTestConsole = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationServer(ctx, "authorizationServer", &apimanagement.AuthorizationServerArgs{
 * 			AuthorizationEndpoint: pulumi.String("https://www.contoso.com/oauth2/auth"),
 * 			AuthorizationMethods: []apimanagement.AuthorizationMethod{
 * 				apimanagement.AuthorizationMethodGET,
 * 			},
 * 			Authsid: pulumi.String("newauthServer"),
 * 			BearerTokenSendingMethods: pulumi.StringArray{
 * 				pulumi.String("authorizationHeader"),
 * 			},
 * 			ClientId:                   pulumi.String("1"),
 * 			ClientRegistrationEndpoint: pulumi.String("https://www.contoso.com/apps"),
 * 			ClientSecret:               pulumi.String("2"),
 * 			DefaultScope:               pulumi.String("read write"),
 * 			Description:                pulumi.String("test server"),
 * 			DisplayName:                pulumi.String("test2"),
 * 			GrantTypes: pulumi.StringArray{
 * 				pulumi.String("authorizationCode"),
 * 				pulumi.String("implicit"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ResourceOwnerPassword: pulumi.String("pwd"),
 * 			ResourceOwnerUsername: pulumi.String("un"),
 * 			ServiceName:           pulumi.String("apimService1"),
 * 			SupportState:          pulumi.Bool(true),
 * 			TokenEndpoint:         pulumi.String("https://www.contoso.com/oauth2/token"),
 * 			UseInApiDocumentation: pulumi.Bool(true),
 * 			UseInTestConsole:      pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationServer;
 * import com.pulumi.azurenative.apimanagement.AuthorizationServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationServer = new AuthorizationServer("authorizationServer", AuthorizationServerArgs.builder()
 *             .authorizationEndpoint("https://www.contoso.com/oauth2/auth")
 *             .authorizationMethods("GET")
 *             .authsid("newauthServer")
 *             .bearerTokenSendingMethods("authorizationHeader")
 *             .clientId("1")
 *             .clientRegistrationEndpoint("https://www.contoso.com/apps")
 *             .clientSecret("2")
 *             .defaultScope("read write")
 *             .description("test server")
 *             .displayName("test2")
 *             .grantTypes(
 *                 "authorizationCode",
 *                 "implicit")
 *             .resourceGroupName("rg1")
 *             .resourceOwnerPassword("pwd")
 *             .resourceOwnerUsername("un")
 *             .serviceName("apimService1")
 *             .supportState(true)
 *             .tokenEndpoint("https://www.contoso.com/oauth2/token")
 *             .useInApiDocumentation(true)
 *             .useInTestConsole(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:AuthorizationServer newauthServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationServers/{authsid}
 * ```
 * @property authorizationEndpoint OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
 * @property authorizationMethods HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
 * @property authsid Identifier of the authorization server.
 * @property bearerTokenSendingMethods Specifies the mechanism by which access token is passed to the API.
 * @property clientAuthenticationMethod Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
 * @property clientId Client or app id registered with this authorization server.
 * @property clientRegistrationEndpoint Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
 * @property clientSecret Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property defaultScope Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
 * @property description Description of the authorization server. Can contain HTML formatting tags.
 * @property displayName User-friendly authorization server name.
 * @property grantTypes Form of an authorization grant, which the client uses to request the access token.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceOwnerPassword Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
 * @property resourceOwnerUsername Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
 * @property serviceName The name of the API Management service.
 * @property supportState If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
 * @property tokenBodyParameters Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
 * @property tokenEndpoint OAuth token endpoint. Contains absolute URI to entity being referenced.
 * @property useInApiDocumentation If true, the authorization server will be used in the API documentation in the developer portal. False by default if no value is provided.
 * @property useInTestConsole If true, the authorization server may be used in the developer portal test console. True by default if no value is provided.
 */
public data class AuthorizationServerArgs(
    public val authorizationEndpoint: Output<String>? = null,
    public val authorizationMethods: Output<List<AuthorizationMethod>>? = null,
    public val authsid: Output<String>? = null,
    public val bearerTokenSendingMethods: Output<List<Either<String, BearerTokenSendingMethod>>>? =
        null,
    public val clientAuthenticationMethod: Output<List<Either<String, ClientAuthenticationMethod>>>? =
        null,
    public val clientId: Output<String>? = null,
    public val clientRegistrationEndpoint: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val defaultScope: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val grantTypes: Output<List<Either<String, GrantType>>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceOwnerPassword: Output<String>? = null,
    public val resourceOwnerUsername: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val supportState: Output<Boolean>? = null,
    public val tokenBodyParameters: Output<List<TokenBodyParameterContractArgs>>? = null,
    public val tokenEndpoint: Output<String>? = null,
    public val useInApiDocumentation: Output<Boolean>? = null,
    public val useInTestConsole: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.AuthorizationServerArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.AuthorizationServerArgs =
        com.pulumi.azurenative.apimanagement.AuthorizationServerArgs.builder()
            .authorizationEndpoint(authorizationEndpoint?.applyValue({ args0 -> args0 }))
            .authorizationMethods(
                authorizationMethods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .authsid(authsid?.applyValue({ args0 -> args0 }))
            .bearerTokenSendingMethods(
                bearerTokenSendingMethods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .clientAuthenticationMethod(
                clientAuthenticationMethod?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientRegistrationEndpoint(clientRegistrationEndpoint?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .defaultScope(defaultScope?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .grantTypes(
                grantTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceOwnerPassword(resourceOwnerPassword?.applyValue({ args0 -> args0 }))
            .resourceOwnerUsername(resourceOwnerUsername?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .supportState(supportState?.applyValue({ args0 -> args0 }))
            .tokenBodyParameters(
                tokenBodyParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tokenEndpoint(tokenEndpoint?.applyValue({ args0 -> args0 }))
            .useInApiDocumentation(useInApiDocumentation?.applyValue({ args0 -> args0 }))
            .useInTestConsole(useInTestConsole?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationServerArgs].
 */
@PulumiTagMarker
public class AuthorizationServerArgsBuilder internal constructor() {
    private var authorizationEndpoint: Output<String>? = null

    private var authorizationMethods: Output<List<AuthorizationMethod>>? = null

    private var authsid: Output<String>? = null

    private var bearerTokenSendingMethods: Output<List<Either<String, BearerTokenSendingMethod>>>? =
        null

    private var clientAuthenticationMethod: Output<List<Either<String, ClientAuthenticationMethod>>>? =
        null

    private var clientId: Output<String>? = null

    private var clientRegistrationEndpoint: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var defaultScope: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var grantTypes: Output<List<Either<String, GrantType>>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceOwnerPassword: Output<String>? = null

    private var resourceOwnerUsername: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var supportState: Output<Boolean>? = null

    private var tokenBodyParameters: Output<List<TokenBodyParameterContractArgs>>? = null

    private var tokenEndpoint: Output<String>? = null

    private var useInApiDocumentation: Output<Boolean>? = null

    private var useInTestConsole: Output<Boolean>? = null

    /**
     * @param value OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
     */
    @JvmName("ditoxchmnfehbouv")
    public suspend fun authorizationEndpoint(`value`: Output<String>) {
        this.authorizationEndpoint = value
    }

    /**
     * @param value HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
     */
    @JvmName("dapmwgdyebnteeha")
    public suspend fun authorizationMethods(`value`: Output<List<AuthorizationMethod>>) {
        this.authorizationMethods = value
    }

    @JvmName("mbpmqwmvqmluxjtq")
    public suspend fun authorizationMethods(vararg values: Output<AuthorizationMethod>) {
        this.authorizationMethods = Output.all(values.asList())
    }

    /**
     * @param values HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
     */
    @JvmName("skvwgeyosocakffo")
    public suspend fun authorizationMethods(values: List<Output<AuthorizationMethod>>) {
        this.authorizationMethods = Output.all(values)
    }

    /**
     * @param value Identifier of the authorization server.
     */
    @JvmName("pogtcxqfxawgrtxg")
    public suspend fun authsid(`value`: Output<String>) {
        this.authsid = value
    }

    /**
     * @param value Specifies the mechanism by which access token is passed to the API.
     */
    @JvmName("qoyxxntfrffjphpb")
    public suspend
    fun bearerTokenSendingMethods(`value`: Output<List<Either<String, BearerTokenSendingMethod>>>) {
        this.bearerTokenSendingMethods = value
    }

    @JvmName("xenymbxbstrrkxuy")
    public suspend fun bearerTokenSendingMethods(
        vararg
        values: Output<Either<String, BearerTokenSendingMethod>>,
    ) {
        this.bearerTokenSendingMethods = Output.all(values.asList())
    }

    /**
     * @param values Specifies the mechanism by which access token is passed to the API.
     */
    @JvmName("aqhetkbnqhvclgyf")
    public suspend
    fun bearerTokenSendingMethods(values: List<Output<Either<String, BearerTokenSendingMethod>>>) {
        this.bearerTokenSendingMethods = Output.all(values)
    }

    /**
     * @param value Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
     */
    @JvmName("aibkuoiresqbfapr")
    public suspend
    fun clientAuthenticationMethod(`value`: Output<List<Either<String, ClientAuthenticationMethod>>>) {
        this.clientAuthenticationMethod = value
    }

    @JvmName("nutdqxwyiycirxra")
    public suspend fun clientAuthenticationMethod(
        vararg
        values: Output<Either<String, ClientAuthenticationMethod>>,
    ) {
        this.clientAuthenticationMethod = Output.all(values.asList())
    }

    /**
     * @param values Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
     */
    @JvmName("masicufpiedbpmnc")
    public suspend
    fun clientAuthenticationMethod(values: List<Output<Either<String, ClientAuthenticationMethod>>>) {
        this.clientAuthenticationMethod = Output.all(values)
    }

    /**
     * @param value Client or app id registered with this authorization server.
     */
    @JvmName("tjejhiyeudkqxtkj")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
     */
    @JvmName("qamwthnepxcbqcaq")
    public suspend fun clientRegistrationEndpoint(`value`: Output<String>) {
        this.clientRegistrationEndpoint = value
    }

    /**
     * @param value Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
     */
    @JvmName("jfmjhawnsvvrdupw")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
     */
    @JvmName("pycobogfkuohjruc")
    public suspend fun defaultScope(`value`: Output<String>) {
        this.defaultScope = value
    }

    /**
     * @param value Description of the authorization server. Can contain HTML formatting tags.
     */
    @JvmName("mffwwkmnlqqtoyin")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value User-friendly authorization server name.
     */
    @JvmName("kyayfgjvnaomecko")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Form of an authorization grant, which the client uses to request the access token.
     */
    @JvmName("wpsfyvmhpsfxvrge")
    public suspend fun grantTypes(`value`: Output<List<Either<String, GrantType>>>) {
        this.grantTypes = value
    }

    @JvmName("csrqebkcxcnofskt")
    public suspend fun grantTypes(vararg values: Output<Either<String, GrantType>>) {
        this.grantTypes = Output.all(values.asList())
    }

    /**
     * @param values Form of an authorization grant, which the client uses to request the access token.
     */
    @JvmName("buoafgrwppjbrtuw")
    public suspend fun grantTypes(values: List<Output<Either<String, GrantType>>>) {
        this.grantTypes = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yyvabndsdjpaxjpf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
     */
    @JvmName("jovterksybftubcf")
    public suspend fun resourceOwnerPassword(`value`: Output<String>) {
        this.resourceOwnerPassword = value
    }

    /**
     * @param value Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
     */
    @JvmName("uaperhuehdaooegg")
    public suspend fun resourceOwnerUsername(`value`: Output<String>) {
        this.resourceOwnerUsername = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("staasdhyhawyobae")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
     */
    @JvmName("ykxrqnwgkknuuucg")
    public suspend fun supportState(`value`: Output<Boolean>) {
        this.supportState = value
    }

    /**
     * @param value Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    @JvmName("uasevdwbcspcvitj")
    public suspend fun tokenBodyParameters(`value`: Output<List<TokenBodyParameterContractArgs>>) {
        this.tokenBodyParameters = value
    }

    @JvmName("jxekhxwhnawnbmvy")
    public suspend fun tokenBodyParameters(vararg values: Output<TokenBodyParameterContractArgs>) {
        this.tokenBodyParameters = Output.all(values.asList())
    }

    /**
     * @param values Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    @JvmName("bjmnlnlhbykxdcue")
    public suspend fun tokenBodyParameters(values: List<Output<TokenBodyParameterContractArgs>>) {
        this.tokenBodyParameters = Output.all(values)
    }

    /**
     * @param value OAuth token endpoint. Contains absolute URI to entity being referenced.
     */
    @JvmName("evrsmpkpgxskwbyu")
    public suspend fun tokenEndpoint(`value`: Output<String>) {
        this.tokenEndpoint = value
    }

    /**
     * @param value If true, the authorization server will be used in the API documentation in the developer portal. False by default if no value is provided.
     */
    @JvmName("kebogxdmanysaagb")
    public suspend fun useInApiDocumentation(`value`: Output<Boolean>) {
        this.useInApiDocumentation = value
    }

    /**
     * @param value If true, the authorization server may be used in the developer portal test console. True by default if no value is provided.
     */
    @JvmName("vlenhraieoqgyrqa")
    public suspend fun useInTestConsole(`value`: Output<Boolean>) {
        this.useInTestConsole = value
    }

    /**
     * @param value OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
     */
    @JvmName("fblcdascbilamkba")
    public suspend fun authorizationEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationEndpoint = mapped
    }

    /**
     * @param value HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
     */
    @JvmName("piomjbsyolymbqkj")
    public suspend fun authorizationMethods(`value`: List<AuthorizationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationMethods = mapped
    }

    /**
     * @param values HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
     */
    @JvmName("wymrbbpkaaydtdkq")
    public suspend fun authorizationMethods(vararg values: AuthorizationMethod) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationMethods = mapped
    }

    /**
     * @param value Identifier of the authorization server.
     */
    @JvmName("jawmhtouwbchdlqx")
    public suspend fun authsid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authsid = mapped
    }

    /**
     * @param value Specifies the mechanism by which access token is passed to the API.
     */
    @JvmName("pabskriqmfmvilra")
    public suspend
    fun bearerTokenSendingMethods(`value`: List<Either<String, BearerTokenSendingMethod>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bearerTokenSendingMethods = mapped
    }

    /**
     * @param values Specifies the mechanism by which access token is passed to the API.
     */
    @JvmName("kligrsdlkgukxuyd")
    public suspend fun bearerTokenSendingMethods(
        vararg
        values: Either<String, BearerTokenSendingMethod>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bearerTokenSendingMethods = mapped
    }

    /**
     * @param value Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
     */
    @JvmName("clvtpfuewtylyweu")
    public suspend
    fun clientAuthenticationMethod(`value`: List<Either<String, ClientAuthenticationMethod>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuthenticationMethod = mapped
    }

    /**
     * @param values Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
     */
    @JvmName("rktpuvrffsoeetga")
    public suspend fun clientAuthenticationMethod(
        vararg
        values: Either<String, ClientAuthenticationMethod>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientAuthenticationMethod = mapped
    }

    /**
     * @param value Client or app id registered with this authorization server.
     */
    @JvmName("baysulepyuiqtavi")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
     */
    @JvmName("nwqjlvrapmdmqqkh")
    public suspend fun clientRegistrationEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientRegistrationEndpoint = mapped
    }

    /**
     * @param value Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
     */
    @JvmName("viocuqeyffkcjqpm")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
     */
    @JvmName("ydbgcijivvmacrsq")
    public suspend fun defaultScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultScope = mapped
    }

    /**
     * @param value Description of the authorization server. Can contain HTML formatting tags.
     */
    @JvmName("kukvglrkuuirnglj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value User-friendly authorization server name.
     */
    @JvmName("twkvbdrbfkqhrmvw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Form of an authorization grant, which the client uses to request the access token.
     */
    @JvmName("bvphvjmdtloneojg")
    public suspend fun grantTypes(`value`: List<Either<String, GrantType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantTypes = mapped
    }

    /**
     * @param values Form of an authorization grant, which the client uses to request the access token.
     */
    @JvmName("bunqeowregfjcwyn")
    public suspend fun grantTypes(vararg values: Either<String, GrantType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grantTypes = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ehyaumqqwvvaplqf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
     */
    @JvmName("dsrfhncwdfllnbrc")
    public suspend fun resourceOwnerPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceOwnerPassword = mapped
    }

    /**
     * @param value Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
     */
    @JvmName("odtbrwbrtbjajhcq")
    public suspend fun resourceOwnerUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceOwnerUsername = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("gpmoeprcpipfixnk")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
     */
    @JvmName("dhxwrpeokfmrqloe")
    public suspend fun supportState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportState = mapped
    }

    /**
     * @param value Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    @JvmName("agysmjxqjekddtmu")
    public suspend fun tokenBodyParameters(`value`: List<TokenBodyParameterContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenBodyParameters = mapped
    }

    /**
     * @param argument Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    @JvmName("yeqwljueayjjuapp")
    public suspend
    fun tokenBodyParameters(argument: List<suspend TokenBodyParameterContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TokenBodyParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tokenBodyParameters = mapped
    }

    /**
     * @param argument Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    @JvmName("ftrtycbkgecjegcq")
    public suspend fun tokenBodyParameters(
        vararg
        argument: suspend TokenBodyParameterContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TokenBodyParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tokenBodyParameters = mapped
    }

    /**
     * @param argument Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    @JvmName("jhxvwkjucdiwwhij")
    public suspend
    fun tokenBodyParameters(argument: suspend TokenBodyParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TokenBodyParameterContractArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tokenBodyParameters = mapped
    }

    /**
     * @param values Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    @JvmName("noaaqfbkppxqflpj")
    public suspend fun tokenBodyParameters(vararg values: TokenBodyParameterContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenBodyParameters = mapped
    }

    /**
     * @param value OAuth token endpoint. Contains absolute URI to entity being referenced.
     */
    @JvmName("nffcnmfmbhmqswpr")
    public suspend fun tokenEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenEndpoint = mapped
    }

    /**
     * @param value If true, the authorization server will be used in the API documentation in the developer portal. False by default if no value is provided.
     */
    @JvmName("fswkelvtvjxqcqut")
    public suspend fun useInApiDocumentation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useInApiDocumentation = mapped
    }

    /**
     * @param value If true, the authorization server may be used in the developer portal test console. True by default if no value is provided.
     */
    @JvmName("kskvcnqlfjtwgfnn")
    public suspend fun useInTestConsole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useInTestConsole = mapped
    }

    internal fun build(): AuthorizationServerArgs = AuthorizationServerArgs(
        authorizationEndpoint = authorizationEndpoint,
        authorizationMethods = authorizationMethods,
        authsid = authsid,
        bearerTokenSendingMethods = bearerTokenSendingMethods,
        clientAuthenticationMethod = clientAuthenticationMethod,
        clientId = clientId,
        clientRegistrationEndpoint = clientRegistrationEndpoint,
        clientSecret = clientSecret,
        defaultScope = defaultScope,
        description = description,
        displayName = displayName,
        grantTypes = grantTypes,
        resourceGroupName = resourceGroupName,
        resourceOwnerPassword = resourceOwnerPassword,
        resourceOwnerUsername = resourceOwnerUsername,
        serviceName = serviceName,
        supportState = supportState,
        tokenBodyParameters = tokenBodyParameters,
        tokenEndpoint = tokenEndpoint,
        useInApiDocumentation = useInApiDocumentation,
        useInTestConsole = useInTestConsole,
    )
}
