@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ContentTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Content type contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateContentType
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentType = new AzureNative.ApiManagement.ContentType("contentType", new()
 *     {
 *         ContentTypeId = "page",
 *         Description = "A regular page",
 *         Name = "Page",
 *         ResourceGroupName = "rg1",
 *         Schema =
 *         {
 *             { "additionalProperties", false },
 *             { "properties",
 *             {
 *                 { "en_us",
 *                 {
 *                     { "additionalProperties", false },
 *                     { "properties",
 *                     {
 *                         { "description",
 *                         {
 *                             { "description", "Page description. This property gets included in SEO attributes." },
 *                             { "indexed", true },
 *                             { "title", "Description" },
 *                             { "type", "string" },
 *                         } },
 *                         { "documentId",
 *                         {
 *                             { "description", "Reference to page content document." },
 *                             { "title", "Document ID" },
 *                             { "type", "string" },
 *                         } },
 *                         { "keywords",
 *                         {
 *                             { "description", "Page keywords. This property gets included in SEO attributes." },
 *                             { "indexed", true },
 *                             { "title", "Keywords" },
 *                             { "type", "string" },
 *                         } },
 *                         { "permalink",
 *                         {
 *                             { "description", "Page permalink, e.g. '/about'." },
 *                             { "indexed", true },
 *                             { "title", "Permalink" },
 *                             { "type", "string" },
 *                         } },
 *                         { "title",
 *                         {
 *                             { "description", "Page title. This property gets included in SEO attributes." },
 *                             { "indexed", true },
 *                             { "title", "Title" },
 *                             { "type", "string" },
 *                         } },
 *                     } },
 *                     { "required", new[]
 *                     {
 *                         "title",
 *                         "permalink",
 *                         "documentId",
 *                     } },
 *                     { "type", "object" },
 *                 } },
 *             } },
 *         },
 *         ServiceName = "apimService1",
 *         Version = "1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewContentType(ctx, "contentType", &apimanagement.ContentTypeArgs{
 * 			ContentTypeId:     pulumi.String("page"),
 * 			Description:       pulumi.String("A regular page"),
 * 			Name:              pulumi.String("Page"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Schema: pulumi.Any{
 * 				AdditionalProperties: false,
 * 				Properties: map[string]interface{}{
 * 					"en_us": map[string]interface{}{
 * 						"additionalProperties": false,
 * 						"properties": map[string]interface{}{
 * 							"description": map[string]interface{}{
 * 								"description": "Page description. This property gets included in SEO attributes.",
 * 								"indexed":     true,
 * 								"title":       "Description",
 * 								"type":        "string",
 * 							},
 * 							"documentId": map[string]interface{}{
 * 								"description": "Reference to page content document.",
 * 								"title":       "Document ID",
 * 								"type":        "string",
 * 							},
 * 							"keywords": map[string]interface{}{
 * 								"description": "Page keywords. This property gets included in SEO attributes.",
 * 								"indexed":     true,
 * 								"title":       "Keywords",
 * 								"type":        "string",
 * 							},
 * 							"permalink": map[string]interface{}{
 * 								"description": "Page permalink, e.g. '/about'.",
 * 								"indexed":     true,
 * 								"title":       "Permalink",
 * 								"type":        "string",
 * 							},
 * 							"title": map[string]interface{}{
 * 								"description": "Page title. This property gets included in SEO attributes.",
 * 								"indexed":     true,
 * 								"title":       "Title",
 * 								"type":        "string",
 * 							},
 * 						},
 * 						"required": []string{
 * 							"title",
 * 							"permalink",
 * 							"documentId",
 * 						},
 * 						"type": "object",
 * 					},
 * 				},
 * 			},
 * 			ServiceName: pulumi.String("apimService1"),
 * 			Version:     pulumi.String("1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ContentType;
 * import com.pulumi.azurenative.apimanagement.ContentTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentType = new ContentType("contentType", ContentTypeArgs.builder()
 *             .contentTypeId("page")
 *             .description("A regular page")
 *             .name("Page")
 *             .resourceGroupName("rg1")
 *             .schema(Map.ofEntries(
 *                 Map.entry("additionalProperties", false),
 *                 Map.entry("properties", Map.of("en_us", Map.ofEntries(
 *                     Map.entry("additionalProperties", false),
 *                     Map.entry("properties", Map.ofEntries(
 *                         Map.entry("description", Map.ofEntries(
 *                             Map.entry("description", "Page description. This property gets included in SEO attributes."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Description"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("documentId", Map.ofEntries(
 *                             Map.entry("description", "Reference to page content document."),
 *                             Map.entry("title", "Document ID"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("keywords", Map.ofEntries(
 *                             Map.entry("description", "Page keywords. This property gets included in SEO attributes."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Keywords"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("permalink", Map.ofEntries(
 *                             Map.entry("description", "Page permalink, e.g. '/about'."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Permalink"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("title", Map.ofEntries(
 *                             Map.entry("description", "Page title. This property gets included in SEO attributes."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Title"),
 *                             Map.entry("type", "string")
 *                         ))
 *                     )),
 *                     Map.entry("required",
 *                         "title",
 *                         "permalink",
 *                         "documentId"),
 *                     Map.entry("type", "object")
 *                 )))
 *             ))
 *             .serviceName("apimService1")
 *             .version("1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ContentType page /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/contentTypes/{contentTypeId}
 * ```
 * @property contentTypeId Content type identifier.
 * @property description Content type description.
 * @property id Content type identifier
 * @property name Content type name. Must be 1 to 250 characters long.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schema Content type schema.
 * @property serviceName The name of the API Management service.
 * @property version Content type version.
 */
public data class ContentTypeArgs(
    public val contentTypeId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schema: Output<Any>? = null,
    public val serviceName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ContentTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ContentTypeArgs =
        com.pulumi.azurenative.apimanagement.ContentTypeArgs.builder()
            .contentTypeId(contentTypeId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentTypeArgs].
 */
@PulumiTagMarker
public class ContentTypeArgsBuilder internal constructor() {
    private var contentTypeId: Output<String>? = null

    private var description: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schema: Output<Any>? = null

    private var serviceName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Content type identifier.
     */
    @JvmName("opvbtrefsuucwvft")
    public suspend fun contentTypeId(`value`: Output<String>) {
        this.contentTypeId = value
    }

    /**
     * @param value Content type description.
     */
    @JvmName("mqtnpbyeioiercwb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Content type identifier
     */
    @JvmName("uaahlncvlidcxrau")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Content type name. Must be 1 to 250 characters long.
     */
    @JvmName("qrmrbthkcqfolfpu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vkobhhjanubtxscy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Content type schema.
     */
    @JvmName("tcpemqnxavqhawbk")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qlmsqpjpkbtrmsxc")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Content type version.
     */
    @JvmName("thjokqyastiecdtk")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Content type identifier.
     */
    @JvmName("doycnvxxkwmptduj")
    public suspend fun contentTypeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeId = mapped
    }

    /**
     * @param value Content type description.
     */
    @JvmName("ccxvbemwxvvcjgmt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Content type identifier
     */
    @JvmName("ortohmwsqvocqufu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Content type name. Must be 1 to 250 characters long.
     */
    @JvmName("yvtkrtnlmrovvocf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tyckeoclgntugpye")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Content type schema.
     */
    @JvmName("ekvoevsxuiyoyjnp")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("cotrqtepvxkvnhpg")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Content type version.
     */
    @JvmName("uvqxcieoamgldysm")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ContentTypeArgs = ContentTypeArgs(
        contentTypeId = contentTypeId,
        description = description,
        id = id,
        name = name,
        resourceGroupName = resourceGroupName,
        schema = schema,
        serviceName = serviceName,
        version = version,
    )
}
