@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.DocumentationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Markdown documentation details.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateDocumentation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var documentation = new AzureNative.ApiManagement.Documentation("documentation", new()
 *     {
 *         Content = "content",
 *         DocumentationId = "57d1f7558aa04f15146d9d8a",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Title = "Title",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewDocumentation(ctx, "documentation", &apimanagement.DocumentationArgs{
 * 			Content:           pulumi.String("content"),
 * 			DocumentationId:   pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Title:             pulumi.String("Title"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Documentation;
 * import com.pulumi.azurenative.apimanagement.DocumentationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var documentation = new Documentation("documentation", DocumentationArgs.builder()
 *             .content("content")
 *             .documentationId("57d1f7558aa04f15146d9d8a")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .title("Title")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Documentation 57d1f7558aa04f15146d9d8a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/documentations/{documentationId}
 * ```
 * @property content Markdown documentation content.
 * @property documentationId Documentation identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property title documentation title.
 */
public data class DocumentationArgs(
    public val content: Output<String>? = null,
    public val documentationId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.DocumentationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.DocumentationArgs =
        com.pulumi.azurenative.apimanagement.DocumentationArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .documentationId(documentationId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentationArgs].
 */
@PulumiTagMarker
public class DocumentationArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var documentationId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Markdown documentation content.
     */
    @JvmName("uojbxwawstmwcaqa")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Documentation identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wlsircrkydqslvbs")
    public suspend fun documentationId(`value`: Output<String>) {
        this.documentationId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("smpjgbtkxkbmdsua")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("mrbqttunlnnufdfi")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value documentation title.
     */
    @JvmName("gaibokkjimduuneb")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Markdown documentation content.
     */
    @JvmName("tbstnsofltmxdwsb")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Documentation identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("vmkpvtukrmydpcnj")
    public suspend fun documentationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jpmnskfjrynewfhw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xxticfusyxmqvsgl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value documentation title.
     */
    @JvmName("ufuuaqeuwhoedjdr")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): DocumentationArgs = DocumentationArgs(
        content = content,
        documentationId = documentationId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        title = title,
    )
}
