@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GlobalSchema].
 */
@PulumiTagMarker
public class GlobalSchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalSchemaArgs = GlobalSchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalSchemaArgsBuilder.() -> Unit) {
        val builder = GlobalSchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GlobalSchema {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.GlobalSchema(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GlobalSchema(builtJavaResource)
    }
}

/**
 * Global Schema Contract details.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateSchema1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalSchema = new AzureNative.ApiManagement.GlobalSchema("globalSchema", new()
 *     {
 *         Description = "sample schema description",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "schema1",
 *         SchemaType = "xml",
 *         ServiceName = "apimService1",
 *         Value = @"<xsd:schema xmlns:xsd=""http://www.w3.org/2001/XMLSchema""
 *            xmlns:tns=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            targetNamespace=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            elementFormDefault=""qualified"">
 *  <xsd:element name=""PurchaseOrder"" type=""tns:PurchaseOrderType""/>
 *  <xsd:complexType name=""PurchaseOrderType"">
 *   <xsd:sequence>
 *    <xsd:element name=""ShipTo"" type=""tns:USAddress"" maxOccurs=""2""/>
 *    <xsd:element name=""BillTo"" type=""tns:USAddress""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""OrderDate"" type=""xsd:date""/>
 *  </xsd:complexType>
 *  <xsd:complexType name=""USAddress"">
 *   <xsd:sequence>
 *    <xsd:element name=""name""   type=""xsd:string""/>
 *    <xsd:element name=""street"" type=""xsd:string""/>
 *    <xsd:element name=""city""   type=""xsd:string""/>
 *    <xsd:element name=""state""  type=""xsd:string""/>
 *    <xsd:element name=""zip""    type=""xsd:integer""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""country"" type=""xsd:NMTOKEN"" fixed=""US""/>
 *  </xsd:complexType>
 * </xsd:schema>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGlobalSchema(ctx, "globalSchema", &apimanagement.GlobalSchemaArgs{
 * 			Description:       pulumi.String("sample schema description"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("schema1"),
 * 			SchemaType:        pulumi.String("xml"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.Any(`<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>`),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GlobalSchema;
 * import com.pulumi.azurenative.apimanagement.GlobalSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalSchema = new GlobalSchema("globalSchema", GlobalSchemaArgs.builder()
 *             .description("sample schema description")
 *             .resourceGroupName("rg1")
 *             .schemaId("schema1")
 *             .schemaType("xml")
 *             .serviceName("apimService1")
 *             .value("""
 * <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>            """)
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateSchema2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalSchema = new AzureNative.ApiManagement.GlobalSchema("globalSchema", new()
 *     {
 *         Description = "sample schema description",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "schema1",
 *         SchemaType = "json",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGlobalSchema(ctx, "globalSchema", &apimanagement.GlobalSchemaArgs{
 * 			Description:       pulumi.String("sample schema description"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("schema1"),
 * 			SchemaType:        pulumi.String("json"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GlobalSchema;
 * import com.pulumi.azurenative.apimanagement.GlobalSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalSchema = new GlobalSchema("globalSchema", GlobalSchemaArgs.builder()
 *             .description("sample schema description")
 *             .resourceGroupName("rg1")
 *             .schemaId("schema1")
 *             .schemaType("json")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GlobalSchema schema1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/schemas/{schemaId}
 * ```
 */
public class GlobalSchema internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.GlobalSchema,
) : KotlinCustomResource(javaResource, GlobalSchemaMapper) {
    /**
     * Free-form schema entity description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Schema Type. Immutable.
     */
    public val schemaType: Output<String>
        get() = javaResource.schemaType().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Json-encoded string for non json-based schema.
     */
    public val `value`: Output<Any>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object GlobalSchemaMapper : ResourceMapper<GlobalSchema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.GlobalSchema::class == javaResource::class

    override fun map(javaResource: Resource): GlobalSchema = GlobalSchema(
        javaResource as
            com.pulumi.azurenative.apimanagement.GlobalSchema,
    )
}

/**
 * @see [GlobalSchema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalSchema].
 */
public suspend fun globalSchema(
    name: String,
    block: suspend GlobalSchemaResourceBuilder.() -> Unit,
): GlobalSchema {
    val builder = GlobalSchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalSchema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalSchema(name: String): GlobalSchema {
    val builder = GlobalSchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
