@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicyArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.PolicyContentFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy Contract details.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGraphQLApiResolverPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphQLApiResolverPolicy = new AzureNative.ApiManagement.GraphQLApiResolverPolicy("graphQLApiResolverPolicy", new()
 *     {
 *         ApiId = "5600b57e7e8880006a040001",
 *         Format = "xml",
 *         PolicyId = "policy",
 *         ResolverId = "5600b57e7e8880006a080001",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<http-data-source><http-request><set-method>GET</set-method><set-backend-service base-url=\"https://some.service.com\" /><set-url>/api/users</set-url></http-request></http-data-source>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGraphQLApiResolverPolicy(ctx, "graphQLApiResolverPolicy", &apimanagement.GraphQLApiResolverPolicyArgs{
 * 			ApiId:             pulumi.String("5600b57e7e8880006a040001"),
 * 			Format:            pulumi.String("xml"),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResolverId:        pulumi.String("5600b57e7e8880006a080001"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<http-data-source><http-request><set-method>GET</set-method><set-backend-service base-url=\"https://some.service.com\" /><set-url>/api/users</set-url></http-request></http-data-source>"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicy;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphQLApiResolverPolicy = new GraphQLApiResolverPolicy("graphQLApiResolverPolicy", GraphQLApiResolverPolicyArgs.builder()
 *             .apiId("5600b57e7e8880006a040001")
 *             .format("xml")
 *             .policyId("policy")
 *             .resolverId("5600b57e7e8880006a080001")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<http-data-source><http-request><set-method>GET</set-method><set-backend-service base-url=\"https://some.service.com\" /><set-url>/api/users</set-url></http-request></http-data-source>")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GraphQLApiResolverPolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}/policies/{policyId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property format Format of the policyContent.
 * @property policyId The identifier of the Policy.
 * @property resolverId Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property value Contents of the Policy as defined by the format.
 */
public data class GraphQLApiResolverPolicyArgs(
    public val apiId: Output<String>? = null,
    public val format: Output<Either<String, PolicyContentFormat>>? = null,
    public val policyId: Output<String>? = null,
    public val resolverId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicyArgs =
        com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicyArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .resolverId(resolverId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiResolverPolicyArgs].
 */
@PulumiTagMarker
public class GraphQLApiResolverPolicyArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var format: Output<Either<String, PolicyContentFormat>>? = null

    private var policyId: Output<String>? = null

    private var resolverId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("upfnfoyskrmsjomo")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("vtuaaekhcmqbymem")
    public suspend fun format(`value`: Output<Either<String, PolicyContentFormat>>) {
        this.format = value
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("jtfotbakgiorvpyy")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
     */
    @JvmName("nuuhqtlfrkwclumf")
    public suspend fun resolverId(`value`: Output<String>) {
        this.resolverId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mhhihiicaeudpdxt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("cdwwslfveqjxdugp")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("qjjnxytpexbjjmpa")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("rwhuswwwcdoygusb")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("oqsowtfxfmsfepto")
    public suspend fun format(`value`: Either<String, PolicyContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("hcypxxopwejgifub")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("wthigubydmcmjcsl")
    public fun format(`value`: PolicyContentFormat) {
        val toBeMapped = Either.ofRight<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("llsgeafragrumrav")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Resolver identifier within a GraphQL API. Must be unique in the current API Management service instance.
     */
    @JvmName("opsbqsmirfopcedu")
    public suspend fun resolverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolverId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qwbgwkdfnxqusxtj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("lnqohhsqaostxybp")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("fcfvbrovyoqwwtul")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GraphQLApiResolverPolicyArgs = GraphQLApiResolverPolicyArgs(
        apiId = apiId,
        format = format,
        policyId = policyId,
        resolverId = resolverId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        `value` = `value`,
    )
}
