@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.NotificationRecipientEmailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Recipient Email details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateNotificationRecipientEmail
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationRecipientEmail = new AzureNative.ApiManagement.NotificationRecipientEmail("notificationRecipientEmail", new()
 *     {
 *         Email = "foobar@live.com",
 *         NotificationName = "RequestPublisherNotificationMessage",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewNotificationRecipientEmail(ctx, "notificationRecipientEmail", &apimanagement.NotificationRecipientEmailArgs{
 * 			Email:             pulumi.String("foobar@live.com"),
 * 			NotificationName:  pulumi.String("RequestPublisherNotificationMessage"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.NotificationRecipientEmail;
 * import com.pulumi.azurenative.apimanagement.NotificationRecipientEmailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationRecipientEmail = new NotificationRecipientEmail("notificationRecipientEmail", NotificationRecipientEmailArgs.builder()
 *             .email("foobar@live.com")
 *             .notificationName("RequestPublisherNotificationMessage")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:NotificationRecipientEmail foobar@live.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}
 * ```
 * @property email Email identifier.
 * @property notificationName Notification Name Identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class NotificationRecipientEmailArgs(
    public val email: Output<String>? = null,
    public val notificationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.NotificationRecipientEmailArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.NotificationRecipientEmailArgs =
        com.pulumi.azurenative.apimanagement.NotificationRecipientEmailArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .notificationName(notificationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationRecipientEmailArgs].
 */
@PulumiTagMarker
public class NotificationRecipientEmailArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var notificationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Email identifier.
     */
    @JvmName("dttysjyrqnjovjqx")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Notification Name Identifier.
     */
    @JvmName("fdlptjvwiptsgqlk")
    public suspend fun notificationName(`value`: Output<String>) {
        this.notificationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cecdtpbbyceqwdux")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("bmftrqxwacvotbcj")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Email identifier.
     */
    @JvmName("jkggeujcktodasdm")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Notification Name Identifier.
     */
    @JvmName("gkigiwfjqxeymjgc")
    public suspend fun notificationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qbarwxfqovdpdxgc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("lliqndcskrylfyds")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): NotificationRecipientEmailArgs = NotificationRecipientEmailArgs(
        email = email,
        notificationName = notificationName,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
