@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByNameArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.PrivateEndpointConnectionRequestPropertiesArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.PrivateEndpointConnectionRequestPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementApproveOrRejectPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionByName = new AzureNative.ApiManagement.PrivateEndpointConnectionByName("privateEndpointConnectionByName", new()
 *     {
 *         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/privateEndpointConnections/connectionName",
 *         PrivateEndpointConnectionName = "privateEndpointConnectionName",
 *         Properties = new AzureNative.ApiManagement.Inputs.PrivateEndpointConnectionRequestPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.ApiManagement.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "The Private Endpoint Connection is approved.",
 *                 Status = "Approved",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewPrivateEndpointConnectionByName(ctx, "privateEndpointConnectionByName", &apimanagement.PrivateEndpointConnectionByNameArgs{
 * 			Id:                            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/privateEndpointConnections/connectionName"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointConnectionName"),
 * 			Properties: &apimanagement.PrivateEndpointConnectionRequestPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &apimanagement.PrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("The Private Endpoint Connection is approved."),
 * 					Status:      pulumi.String("Approved"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByName;
 * import com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionByName = new PrivateEndpointConnectionByName("privateEndpointConnectionByName", PrivateEndpointConnectionByNameArgs.builder()
 *             .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/privateEndpointConnections/connectionName")
 *             .privateEndpointConnectionName("privateEndpointConnectionName")
 *             .properties(Map.of("privateLinkServiceConnectionState", Map.ofEntries(
 *                 Map.entry("description", "The Private Endpoint Connection is approved."),
 *                 Map.entry("status", "Approved")
 *             )))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:PrivateEndpointConnectionByName privateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property id Private Endpoint Connection Resource Id.
 * @property privateEndpointConnectionName Name of the private endpoint connection.
 * @property properties The connection state of the private endpoint connection.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class PrivateEndpointConnectionByNameArgs(
    public val id: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties: Output<PrivateEndpointConnectionRequestPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByNameArgs =
        com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByNameArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionByNameArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionByNameArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var properties: Output<PrivateEndpointConnectionRequestPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Private Endpoint Connection Resource Id.
     */
    @JvmName("pydanxcfrvhpwyad")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the private endpoint connection.
     */
    @JvmName("puvgncbmjdciasal")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value The connection state of the private endpoint connection.
     */
    @JvmName("ifoyvcvojoghnueo")
    public suspend fun properties(`value`: Output<PrivateEndpointConnectionRequestPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gfkgonnasbxqcsmo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("fncwqqkeaooympvk")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Private Endpoint Connection Resource Id.
     */
    @JvmName("jcpsgonwrxxolrno")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the private endpoint connection.
     */
    @JvmName("utugimgjquktqweb")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The connection state of the private endpoint connection.
     */
    @JvmName("mnkifnpryguadeay")
    public suspend fun properties(`value`: PrivateEndpointConnectionRequestPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The connection state of the private endpoint connection.
     */
    @JvmName("luhnryekdjnaueik")
    public suspend
    fun properties(argument: suspend PrivateEndpointConnectionRequestPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionRequestPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cjklwauvtfxyjrdh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("cedcjfrloupmxinv")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): PrivateEndpointConnectionByNameArgs = PrivateEndpointConnectionByNameArgs(
        id = id,
        privateEndpointConnectionName = privateEndpointConnectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
