@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ProductArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.ProductState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Product details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProduct
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var product = new AzureNative.ApiManagement.Product("product", new()
 *     {
 *         DisplayName = "Test Template ProductName 4",
 *         ProductId = "testproduct",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProduct(ctx, "product", &apimanagement.ProductArgs{
 * 			DisplayName:       pulumi.String("Test Template ProductName 4"),
 * 			ProductId:         pulumi.String("testproduct"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Product;
 * import com.pulumi.azurenative.apimanagement.ProductArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var product = new Product("product", ProductArgs.builder()
 *             .displayName("Test Template ProductName 4")
 *             .productId("testproduct")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Product testproduct /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}
 * ```
 * @property approvalRequired whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
 * @property description Product description. May include HTML formatting tags.
 * @property displayName Product name.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property state whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished.
 * @property subscriptionRequired Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
 * @property subscriptionsLimit Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
 * @property terms Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
 */
public data class ProductArgs(
    public val approvalRequired: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val state: Output<ProductState>? = null,
    public val subscriptionRequired: Output<Boolean>? = null,
    public val subscriptionsLimit: Output<Int>? = null,
    public val terms: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ProductArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ProductArgs =
        com.pulumi.azurenative.apimanagement.ProductArgs.builder()
            .approvalRequired(approvalRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subscriptionRequired(subscriptionRequired?.applyValue({ args0 -> args0 }))
            .subscriptionsLimit(subscriptionsLimit?.applyValue({ args0 -> args0 }))
            .terms(terms?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductArgs].
 */
@PulumiTagMarker
public class ProductArgsBuilder internal constructor() {
    private var approvalRequired: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var productId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var state: Output<ProductState>? = null

    private var subscriptionRequired: Output<Boolean>? = null

    private var subscriptionsLimit: Output<Int>? = null

    private var terms: Output<String>? = null

    /**
     * @param value whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
     */
    @JvmName("ppkhprmtigtokutv")
    public suspend fun approvalRequired(`value`: Output<Boolean>) {
        this.approvalRequired = value
    }

    /**
     * @param value Product description. May include HTML formatting tags.
     */
    @JvmName("mqmcblyrxyjacocx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Product name.
     */
    @JvmName("jjnoskebggnfncqv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("omuiqlckrdgjufug")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rnhryjivqmwtkdtl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("wumbxyrlivuyltbi")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished.
     */
    @JvmName("kkvrneprupyodgen")
    public suspend fun state(`value`: Output<ProductState>) {
        this.state = value
    }

    /**
     * @param value Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
     */
    @JvmName("btbhbqgaaqnobhsb")
    public suspend fun subscriptionRequired(`value`: Output<Boolean>) {
        this.subscriptionRequired = value
    }

    /**
     * @param value Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
     */
    @JvmName("klyvcscecppclrav")
    public suspend fun subscriptionsLimit(`value`: Output<Int>) {
        this.subscriptionsLimit = value
    }

    /**
     * @param value Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
     */
    @JvmName("aatbalojrifkplpi")
    public suspend fun terms(`value`: Output<String>) {
        this.terms = value
    }

    /**
     * @param value whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
     */
    @JvmName("viikciuaavfukfmo")
    public suspend fun approvalRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalRequired = mapped
    }

    /**
     * @param value Product description. May include HTML formatting tags.
     */
    @JvmName("owtnmjbucdrtoocr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Product name.
     */
    @JvmName("xjgyprdbuythwels")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ukwawcbwwufjyyri")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vjrihmgxoqlgidit")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("oiwemnehfqslnywq")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished.
     */
    @JvmName("bxhrmmcjhrxutupa")
    public suspend fun state(`value`: ProductState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
     */
    @JvmName("iayyjvqdmnxkmuqn")
    public suspend fun subscriptionRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionRequired = mapped
    }

    /**
     * @param value Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
     */
    @JvmName("smncacfchchldyai")
    public suspend fun subscriptionsLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionsLimit = mapped
    }

    /**
     * @param value Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
     */
    @JvmName("meudjokntiyifuub")
    public suspend fun terms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terms = mapped
    }

    internal fun build(): ProductArgs = ProductArgs(
        approvalRequired = approvalRequired,
        description = description,
        displayName = displayName,
        productId = productId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        state = state,
        subscriptionRequired = subscriptionRequired,
        subscriptionsLimit = subscriptionsLimit,
        terms = terms,
    )
}
