@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.GroupType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceGroup = new AzureNative.ApiManagement.WorkspaceGroup("workspaceGroup", new()
 *     {
 *         DisplayName = "temp group",
 *         GroupId = "tempgroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceGroup(ctx, "workspaceGroup", &apimanagement.WorkspaceGroupArgs{
 * 			DisplayName:       pulumi.String("temp group"),
 * 			GroupId:           pulumi.String("tempgroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroup;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceGroup = new WorkspaceGroup("workspaceGroup", WorkspaceGroupArgs.builder()
 *             .displayName("temp group")
 *             .groupId("tempgroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateWorkspaceGroupExternal
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceGroup = new AzureNative.ApiManagement.WorkspaceGroup("workspaceGroup", new()
 *     {
 *         Description = "new group to test",
 *         DisplayName = "NewGroup (samiraad.onmicrosoft.com)",
 *         ExternalId = "aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d",
 *         GroupId = "aadGroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Type = AzureNative.ApiManagement.GroupType.External,
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceGroup(ctx, "workspaceGroup", &apimanagement.WorkspaceGroupArgs{
 * 			Description:       pulumi.String("new group to test"),
 * 			DisplayName:       pulumi.String("NewGroup (samiraad.onmicrosoft.com)"),
 * 			ExternalId:        pulumi.String("aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d"),
 * 			GroupId:           pulumi.String("aadGroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Type:              apimanagement.GroupTypeExternal,
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroup;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceGroup = new WorkspaceGroup("workspaceGroup", WorkspaceGroupArgs.builder()
 *             .description("new group to test")
 *             .displayName("NewGroup (samiraad.onmicrosoft.com)")
 *             .externalId("aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d")
 *             .groupId("aadGroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .type("external")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceGroup aadGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/groups/{groupId}
 * ```
 * @property description Group description.
 * @property displayName Group name.
 * @property externalId Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
 * @property groupId Group identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property type Group type.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceGroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val externalId: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val type: Output<GroupType>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceGroupArgs].
 */
@PulumiTagMarker
public class WorkspaceGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var externalId: Output<String>? = null

    private var groupId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var type: Output<GroupType>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Group description.
     */
    @JvmName("qesehxauvsxihxkg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Group name.
     */
    @JvmName("tcpcairnbxlktawg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
     */
    @JvmName("rcsfqjrqgvxvfkkh")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("fvnaeimbjctljaum")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rcfsslufrtotpsqp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xfhbetatubrywiqb")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Group type.
     */
    @JvmName("spityqrqwcmqkrpv")
    public suspend fun type(`value`: Output<GroupType>) {
        this.type = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("hecgujkybpondcsn")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Group description.
     */
    @JvmName("qsbadbhobrksvafx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Group name.
     */
    @JvmName("tjftprijmttmtoxp")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
     */
    @JvmName("krsclsedhftuynug")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("joqelpeeuxvmowyw")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mytaypouljafrhvt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("yugrabbncwhqyqpk")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Group type.
     */
    @JvmName("srxlbtrontwhlerx")
    public suspend fun type(`value`: GroupType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("hyywfnypekojmqwm")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceGroupArgs = WorkspaceGroupArgs(
        description = description,
        displayName = displayName,
        externalId = externalId,
        groupId = groupId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        type = type,
        workspaceId = workspaceId,
    )
}
