@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceNotificationRecipientEmail].
 */
@PulumiTagMarker
public class WorkspaceNotificationRecipientEmailResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceNotificationRecipientEmailArgs =
        WorkspaceNotificationRecipientEmailArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend WorkspaceNotificationRecipientEmailArgsBuilder.() -> Unit) {
        val builder = WorkspaceNotificationRecipientEmailArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceNotificationRecipientEmail {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmail(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceNotificationRecipientEmail(builtJavaResource)
    }
}

/**
 * Recipient Email details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceNotificationRecipientEmail
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceNotificationRecipientEmail = new AzureNative.ApiManagement.WorkspaceNotificationRecipientEmail("workspaceNotificationRecipientEmail", new()
 *     {
 *         Email = "foobar@live.com",
 *         NotificationName = "RequestPublisherNotificationMessage",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceNotificationRecipientEmail(ctx, "workspaceNotificationRecipientEmail", &apimanagement.WorkspaceNotificationRecipientEmailArgs{
 * 			Email:             pulumi.String("foobar@live.com"),
 * 			NotificationName:  pulumi.String("RequestPublisherNotificationMessage"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmail;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceNotificationRecipientEmail = new WorkspaceNotificationRecipientEmail("workspaceNotificationRecipientEmail", WorkspaceNotificationRecipientEmailArgs.builder()
 *             .email("foobar@live.com")
 *             .notificationName("RequestPublisherNotificationMessage")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceNotificationRecipientEmail foobar@live.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/notifications/{notificationName}/recipientEmails/{email}
 * ```
 */
public class WorkspaceNotificationRecipientEmail internal constructor(
    override val javaResource:
    com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmail,
) : KotlinCustomResource(javaResource, WorkspaceNotificationRecipientEmailMapper) {
    /**
     * User Email subscribed to notification.
     */
    public val email: Output<String>?
        get() = javaResource.email().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceNotificationRecipientEmailMapper :
    ResourceMapper<WorkspaceNotificationRecipientEmail> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmail::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceNotificationRecipientEmail =
        WorkspaceNotificationRecipientEmail(
            javaResource as
                com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientEmail,
        )
}

/**
 * @see [WorkspaceNotificationRecipientEmail].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceNotificationRecipientEmail].
 */
public suspend fun workspaceNotificationRecipientEmail(
    name: String,
    block: suspend WorkspaceNotificationRecipientEmailResourceBuilder.() -> Unit,
):
    WorkspaceNotificationRecipientEmail {
    val builder = WorkspaceNotificationRecipientEmailResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceNotificationRecipientEmail].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceNotificationRecipientEmail(name: String): WorkspaceNotificationRecipientEmail {
    val builder = WorkspaceNotificationRecipientEmailResourceBuilder()
    builder.name(name)
    return builder.build()
}
