@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines the type of application which send the create user request. Default is legacy portal.
 */
public enum class AppType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.AppType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.AppType> {
    /**
     * User create request was sent by legacy developer portal.
     */
    Portal(com.pulumi.azurenative.apimanagement.enums.AppType.Portal),

    /**
     * User create request was sent by new developer portal.
     */
    DeveloperPortal(com.pulumi.azurenative.apimanagement.enums.AppType.DeveloperPortal),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.AppType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.AppType): AppType =
            AppType.values().first { it.javaValue == javaType }
    }
}
